/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hibernate;

import java.util.List;
import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.FindImplementations;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaCoordinates;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeTree;
import org.openrewrite.java.tree.TypeUtils;

public class EmptyInterceptorToInterface
extends Recipe {
    private final String EMPTY_INTERCEPTOR = "org.hibernate.EmptyInterceptor";
    private final String INTERCEPTOR = "org.hibernate.Interceptor";
    private final String STATEMENT_INSPECTOR = "org.hibernate.resource.jdbc.spi.StatementInspector";
    private static final MethodMatcher ON_PREPARE_STATEMENT = new MethodMatcher("org.hibernate.Interceptor onPrepareStatement(java.lang.String)", true);
    final String displayName = "Replace `extends EmptyInterceptor` with `implements Interceptor` and potentially `StatementInspector`";
    final String description = "In Hibernate 6.0 the `Interceptor` interface received default implementations therefore the NOOP implementation that could be extended was no longer needed. This recipe migrates 5.x `Interceptor#onPrepareStatement(String)` to 6.0 `StatementInspector#inspect()`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new FindImplementations("org.hibernate.EmptyInterceptor"), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.ClassDeclaration visitClassDeclaration(J.ClassDeclaration classDecl, ExecutionContext ctx) {
                J.ClassDeclaration cd = super.visitClassDeclaration(classDecl, (Object)ctx);
                if (cd.getExtends() != null && TypeUtils.isOfClassType((JavaType)cd.getExtends().getType(), (String)"org.hibernate.EmptyInterceptor")) {
                    cd = cd.withExtends(null).withImplements(ListUtils.concat((List)cd.getImplements(), (Object)((TypeTree)TypeTree.build((String)"Interceptor").withType(JavaType.buildType((String)"org.hibernate.Interceptor")).withPrefix(Space.SINGLE_SPACE))));
                    this.maybeAddImport("org.hibernate.Interceptor");
                    if (this.getCursor().pollMessage("prepareStatementFound") != null) {
                        cd = cd.withImplements(ListUtils.concat((List)cd.getImplements(), (Object)((TypeTree)TypeTree.build((String)"StatementInspector").withType(JavaType.buildType((String)"org.hibernate.resource.jdbc.spi.StatementInspector")).withPrefix(Space.SINGLE_SPACE))));
                        this.maybeAddImport("org.hibernate.resource.jdbc.spi.StatementInspector");
                    }
                    this.maybeRemoveImport("org.hibernate.EmptyInterceptor");
                    if (cd.getPadding().getImplements() != null) {
                        cd = cd.getPadding().withImplements(cd.getPadding().getImplements().withBefore(Space.SINGLE_SPACE));
                    }
                }
                return cd;
            }

            public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
                J.MethodDeclaration md = super.visitMethodDeclaration(method, (Object)ctx);
                J.ClassDeclaration cd = (J.ClassDeclaration)this.getCursor().firstEnclosing(J.ClassDeclaration.class);
                if (cd != null && ON_PREPARE_STATEMENT.matches(md, cd)) {
                    this.getCursor().putMessageOnFirstEnclosing(J.ClassDeclaration.class, "prepareStatementFound", (Object)true);
                    J.MethodDeclaration inspectMD = (J.MethodDeclaration)JavaTemplate.apply((String)((md.getLeadingAnnotations().isEmpty() ? "" : "@Override ") + "public String inspect(String overriddenBelow) { return overriddenBelow; }"), (Cursor)this.getCursor(), (JavaCoordinates)md.getCoordinates().replace(), (Object[])new Object[0]);
                    return inspectMD.withPrefix(md.getPrefix()).withLeadingAnnotations(md.getLeadingAnnotations()).withParameters(md.getParameters()).withBody(md.getBody());
                }
                return md;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

