/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.hibernate;

import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JLeftPadded;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.Space;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.Markers;

public class TypeAnnotationParameter
extends Recipe {
    private static final String FQN_TYPE_ANNOTATION = "org.hibernate.annotations.Type";
    private Set<String> IGNORED_FQNS = new HashSet<String>(Arrays.asList("org.hibernate.type.EnumType", "org.hibernate.type.SerializableType", "org.hibernate.type.SerializableToBlobType", "org.hibernate.type.TextType"));

    public String getDisplayName() {
        return "@Type annotation type parameter migration";
    }

    public String getDescription() {
        return "Hibernate 6.x has 'type' parameter of type String replaced with 'value' of type class.";
    }

    @Nullable
    public Duration getEstimatedEffortPerOccurrence() {
        return Duration.ofMinutes(1L);
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaIsoVisitor<ExecutionContext>(){

            public J.Annotation visitAnnotation(J.Annotation annotation, ExecutionContext ctx) {
                J.Annotation a = super.visitAnnotation(annotation, (Object)ctx);
                JavaType.FullyQualified type = TypeUtils.asFullyQualified((JavaType)a.getType());
                if (type != null && TypeAnnotationParameter.FQN_TYPE_ANNOTATION.equals(type.getFullyQualifiedName())) {
                    boolean isOnlyParameter = a.getArguments().size() == 1;
                    a = a.withArguments(ListUtils.map((List)a.getArguments(), arg -> {
                        J.Assignment assignment;
                        if (arg instanceof J.Assignment && (assignment = (J.Assignment)arg).getVariable() instanceof J.Identifier && "type".equals(((J.Identifier)assignment.getVariable()).getSimpleName()) && assignment.getAssignment() instanceof J.Literal) {
                            J.Identifier paramName = (J.Identifier)assignment.getVariable();
                            String fqTypeName = (String)((J.Literal)assignment.getAssignment()).getValue();
                            if (TypeAnnotationParameter.this.IGNORED_FQNS.contains(fqTypeName)) {
                                return arg;
                            }
                            String simpleTypeName = TypeAnnotationParameter.getSimpleName(fqTypeName);
                            JavaType typeOfNewValue = JavaType.buildType((String)fqTypeName);
                            J.FieldAccess fa = new J.FieldAccess(Tree.randomId(), isOnlyParameter ? Space.EMPTY : assignment.getAssignment().getPrefix(), assignment.getAssignment().getMarkers(), (Expression)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), simpleTypeName, typeOfNewValue, null), JLeftPadded.build((Object)new J.Identifier(Tree.randomId(), Space.EMPTY, Markers.EMPTY, Collections.emptyList(), "class", null, null)), JavaType.buildType((String)"java.lang.Class"));
                            this.maybeAddImport(fqTypeName);
                            if (isOnlyParameter) {
                                return fa;
                            }
                            return assignment.withVariable((Expression)paramName.withSimpleName("value")).withAssignment((Expression)fa);
                        }
                        return arg;
                    }));
                }
                return a;
            }
        };
    }

    private static String getSimpleName(String fqName) {
        int idx = fqName.lastIndexOf(46);
        if (idx > 0 && idx < fqName.length() - 1) {
            return fqName.substring(idx + 1);
        }
        return fqName;
    }
}

