/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import lombok.Generated;
import org.openrewrite.Cursor;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class UndocumentedPermissionsRecipe
extends Recipe {
    private final String displayName = "Document permissions usage";
    private final String description = "Add documentation comments for permissions blocks in GitHub Actions workflows. Documenting permissions helps reviewers understand why specific permissions are needed and ensures security-conscious development practices. Based on [zizmor's undocumented-permissions audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/undocumented_permissions.rs).";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new UndocumentedPermissionsVisitor());
    }

    @Generated
    public UndocumentedPermissionsRecipe() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "UndocumentedPermissionsRecipe(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UndocumentedPermissionsRecipe)) {
            return false;
        }
        UndocumentedPermissionsRecipe other = (UndocumentedPermissionsRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof UndocumentedPermissionsRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static class UndocumentedPermissionsVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private UndocumentedPermissionsVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
            if (this.isPermissionsEntry(mappingEntry) && !this.hasDocumentationComment(mappingEntry)) {
                String context = this.getPermissionsContext();
                return (Yaml.Mapping.Entry)SearchResult.found((Tree)mappingEntry, (String)("Permissions block lacks documentation comment. Consider adding a comment explaining why these permissions are needed" + (context != null ? " for " + context : "") + "."));
            }
            return mappingEntry;
        }

        private boolean isPermissionsEntry(Yaml.Mapping.Entry entry) {
            return entry.getKey() instanceof Yaml.Scalar && "permissions".equals(((Yaml.Scalar)entry.getKey()).getValue());
        }

        private boolean hasDocumentationComment(Yaml.Mapping.Entry entry) {
            return false;
        }

        private String getPermissionsContext() {
            for (Cursor cursor = this.getCursor(); cursor != null; cursor = cursor.getParent()) {
                Yaml.Mapping.Entry ggEntry;
                Cursor grandparent;
                Yaml.Mapping.Entry parentEntry;
                if (cursor.getValue() instanceof Yaml.Mapping) {
                    Yaml.Mapping mapping = (Yaml.Mapping)cursor.getValue();
                    for (Yaml.Mapping.Entry entry : mapping.getEntries()) {
                        String key;
                        if (!(entry.getKey() instanceof Yaml.Scalar) || !"jobs".equals(key = ((Yaml.Scalar)entry.getKey()).getValue())) continue;
                        return "workflow";
                    }
                }
                if (cursor.getParent() == null || !(cursor.getParent().getValue() instanceof Yaml.Mapping.Entry) || !((parentEntry = (Yaml.Mapping.Entry)cursor.getParent().getValue()).getKey() instanceof Yaml.Scalar) || (grandparent = cursor.getParent().getParent()) == null || grandparent.getParent() == null || !(grandparent.getParent().getValue() instanceof Yaml.Mapping.Entry) || !((ggEntry = (Yaml.Mapping.Entry)grandparent.getParent().getValue()).getKey() instanceof Yaml.Scalar) || !"jobs".equals(((Yaml.Scalar)ggEntry.getKey()).getValue())) continue;
                return "this job";
            }
            return null;
        }
    }
}

