/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class InsecureCommandsRecipe
extends Recipe {
    private static final String INSECURE_COMMANDS_VAR = "ACTIONS_ALLOW_UNSECURE_COMMANDS";
    private final String displayName = "Find insecure commands configuration";
    private final String description = "Detects when insecure workflow commands are enabled via `ACTIONS_ALLOW_UNSECURE_COMMANDS`. This environment variable enables dangerous workflow commands that can lead to code injection vulnerabilities. Based on [zizmor's insecure-commands audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/insecure_commands.rs).";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                String value;
                Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
                if (this.isInsecureCommandsEntry(mappingEntry) && (value = this.getEnvironmentValue(mappingEntry)) != null && this.isTruthyValue(value)) {
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)mappingEntry, (String)"Insecure commands are enabled via ACTIONS_ALLOW_UNSECURE_COMMANDS. This allows dangerous workflow commands that can lead to code injection. Remove this environment variable to disable insecure commands.");
                }
                return mappingEntry;
            }

            private boolean isInsecureCommandsEntry(Yaml.Mapping.Entry entry) {
                if (!(entry.getKey() instanceof Yaml.Scalar)) {
                    return false;
                }
                String key = ((Yaml.Scalar)entry.getKey()).getValue();
                return InsecureCommandsRecipe.INSECURE_COMMANDS_VAR.equals(key);
            }

            private String getEnvironmentValue(Yaml.Mapping.Entry entry) {
                if (entry.getValue() instanceof Yaml.Scalar) {
                    return ((Yaml.Scalar)entry.getValue()).getValue();
                }
                return null;
            }

            private boolean isTruthyValue(String value) {
                if (value == null) {
                    return false;
                }
                String lowerValue = value.toLowerCase().trim();
                return "true".equals(lowerValue) || "1".equals(lowerValue) || "yes".equals(lowerValue) || "on".equals(lowerValue);
            }
        });
    }

    @Generated
    public InsecureCommandsRecipe() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "InsecureCommandsRecipe(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InsecureCommandsRecipe)) {
            return false;
        }
        InsecureCommandsRecipe other = (InsecureCommandsRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InsecureCommandsRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

