/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class DangerousTriggersRecipe
extends Recipe {
    private static final Set<String> DANGEROUS_TRIGGERS = new HashSet<String>(Arrays.asList("pull_request_target", "workflow_run"));
    private final String displayName = "Find dangerous workflow triggers";
    private final String description = "Detects use of fundamentally insecure workflow triggers like `pull_request_target` and `workflow_run`. These triggers run with elevated privileges and are almost always used insecurely, potentially allowing code injection from untrusted sources. Based on [zizmor's dangerous-triggers audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/dangerous_triggers.rs).";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
                if (this.isOnEntry(mappingEntry)) {
                    return this.checkTriggersInOnEntry(mappingEntry);
                }
                return mappingEntry;
            }

            private boolean isOnEntry(Yaml.Mapping.Entry entry) {
                if (!(entry.getKey() instanceof Yaml.Scalar)) {
                    return false;
                }
                String key = ((Yaml.Scalar)entry.getKey()).getValue();
                return "on".equals(key);
            }

            private Yaml.Mapping.Entry checkTriggersInOnEntry(Yaml.Mapping.Entry onEntry) {
                block4: {
                    Yaml.Block onValue;
                    block5: {
                        block3: {
                            onValue = onEntry.getValue();
                            if (!(onValue instanceof Yaml.Scalar)) break block3;
                            String trigger = ((Yaml.Scalar)onValue).getValue();
                            if (DANGEROUS_TRIGGERS.contains(trigger)) {
                                String message = this.getDangerousTriggersMessage(trigger);
                                return (Yaml.Mapping.Entry)SearchResult.found((Tree)onEntry, (String)message);
                            }
                            break block4;
                        }
                        if (!(onValue instanceof Yaml.Sequence)) break block5;
                        Yaml.Sequence sequence = (Yaml.Sequence)onValue;
                        for (Yaml.Sequence.Entry seqEntry : sequence.getEntries()) {
                            if (!(seqEntry.getBlock() instanceof Yaml.Scalar)) continue;
                            String trigger = ((Yaml.Scalar)seqEntry.getBlock()).getValue();
                            if (!DANGEROUS_TRIGGERS.contains(trigger)) continue;
                            String message = this.getDangerousTriggersMessage(trigger);
                            return (Yaml.Mapping.Entry)SearchResult.found((Tree)onEntry, (String)message);
                        }
                        break block4;
                    }
                    if (!(onValue instanceof Yaml.Mapping)) break block4;
                    Yaml.Mapping mapping = (Yaml.Mapping)onValue;
                    for (Yaml.Mapping.Entry triggerEntry : mapping.getEntries()) {
                        if (!(triggerEntry.getKey() instanceof Yaml.Scalar)) continue;
                        String trigger = ((Yaml.Scalar)triggerEntry.getKey()).getValue();
                        if (!DANGEROUS_TRIGGERS.contains(trigger)) continue;
                        String message = this.getDangerousTriggersMessage(trigger);
                        return (Yaml.Mapping.Entry)SearchResult.found((Tree)onEntry, (String)message);
                    }
                }
                return onEntry;
            }

            private String getDangerousTriggersMessage(String trigger) {
                switch (trigger) {
                    case "pull_request_target": {
                        return "The 'pull_request_target' trigger is almost always used insecurely. It runs with write permissions in the context of the target repository, potentially allowing code injection from pull requests. Consider using 'pull_request' instead, or implement proper isolation.";
                    }
                    case "workflow_run": {
                        return "The 'workflow_run' trigger is almost always used insecurely. It can trigger workflows with sensitive permissions based on external events. Consider using more specific triggers with explicit safety checks.";
                    }
                }
                return String.format("The '%s' trigger is considered insecure and should be avoided.", trigger);
            }
        });
    }

    @Generated
    public DangerousTriggersRecipe() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "DangerousTriggersRecipe(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DangerousTriggersRecipe)) {
            return false;
        }
        DangerousTriggersRecipe other = (DangerousTriggersRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DangerousTriggersRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

