/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github.security;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.github.security.YamlHelper;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public final class CachePoisoningRecipe
extends Recipe {
    private static final Set<String> CACHE_AWARE_ACTIONS = new HashSet<String>(Arrays.asList("actions/cache", "actions/setup-java", "actions/setup-go", "actions/setup-node", "actions/setup-python", "actions/setup-dotnet", "astral-sh/setup-uv", "Swatinem/rust-cache", "ruby/setup-ruby", "PyO3/maturin-action", "mlugg/setup-zig", "oven-sh/setup-bun", "DeterminateSystems/magic-nix-cache-action", "graalvm/setup-graalvm", "gradle/actions/setup-gradle", "docker/setup-buildx-action", "actions-rust-lang/setup-rust-toolchain", "Mozilla-Actions/sccache-action", "nix-community/cache-nix-action", "jdx/mise-action"));
    private static final Set<String> PUBLISHER_ACTIONS = new HashSet<String>(Arrays.asList("pypa/gh-action-pypi-publish", "rubygems/release-gem", "jreleaser/release-action", "goreleaser/goreleaser-action", "softprops/action-gh-release", "release-drafter/release-drafter", "googleapis/release-please-action", "docker/build-push-action", "redhat-actions/push-to-registry"));
    private static final Pattern RELEASE_BRANCH_PATTERN = Pattern.compile(".*release.*", 2);
    private final String displayName = "Find cache poisoning vulnerabilities";
    private final String description = "Detects potential cache poisoning vulnerabilities in workflows that use caching and publish artifacts. When workflows use caches during artifact publishing, attackers may be able to poison the cache with malicious content that gets included in published artifacts. Based on [zizmor's cache-poisoning audit](https://github.com/woodruffw/zizmor/blob/main/crates/zizmor/src/audit/cache_poisoning.rs).";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){
            private boolean isPublishingWorkflow = false;
            private boolean hasPublisherAction = false;

            public Yaml.Document visitDocument(Yaml.Document document, ExecutionContext ctx) {
                this.isPublishingWorkflow = false;
                this.hasPublisherAction = false;
                this.analyzeWorkflow(document);
                if (this.isPublishingWorkflow || this.hasPublisherAction) {
                    return super.visitDocument(document, (Object)ctx);
                }
                return document;
            }

            private void analyzeWorkflow(Yaml.Document document) {
                if (document.getBlock() instanceof Yaml.Mapping) {
                    Yaml.Mapping workflowMapping = (Yaml.Mapping)document.getBlock();
                    for (Yaml.Mapping.Entry entry : workflowMapping.getEntries()) {
                        if (!(entry.getKey() instanceof Yaml.Scalar)) continue;
                        String key = ((Yaml.Scalar)entry.getKey()).getValue();
                        if ("on".equals(key)) {
                            this.isPublishingWorkflow = this.isPublishingTrigger(entry.getValue());
                            continue;
                        }
                        if (!"jobs".equals(key)) continue;
                        this.hasPublisherAction = this.hasPublisherActions(entry.getValue());
                    }
                }
            }

            private boolean isPublishingTrigger(Yaml.Block onValue) {
                block5: {
                    block4: {
                        String scalarTrigger = YamlHelper.getScalarValue(onValue);
                        if (scalarTrigger != null) {
                            return "release".equals(scalarTrigger);
                        }
                        if (!(onValue instanceof Yaml.Sequence)) break block4;
                        Yaml.Sequence sequence = (Yaml.Sequence)onValue;
                        for (Yaml.Sequence.Entry seqEntry : sequence.getEntries()) {
                            String trigger = YamlHelper.getScalarValue(seqEntry.getBlock());
                            if (!"release".equals(trigger)) continue;
                            return true;
                        }
                        break block5;
                    }
                    if (!(onValue instanceof Yaml.Mapping)) break block5;
                    Yaml.Mapping mapping = (Yaml.Mapping)onValue;
                    for (Yaml.Mapping.Entry triggerEntry : mapping.getEntries()) {
                        String trigger = triggerEntry.getKey().getValue();
                        if ("release".equals(trigger)) {
                            return true;
                        }
                        if (!"push".equals(trigger) || !this.isReleasePush(triggerEntry.getValue())) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean isReleasePush(Yaml.Block pushConfig) {
                if (pushConfig instanceof Yaml.Mapping) {
                    Yaml.Mapping mapping = (Yaml.Mapping)pushConfig;
                    for (Yaml.Mapping.Entry entry : mapping.getEntries()) {
                        if (!(entry.getKey() instanceof Yaml.Scalar)) continue;
                        String key = ((Yaml.Scalar)entry.getKey()).getValue();
                        if ("tags".equals(key)) {
                            return true;
                        }
                        if (!"branches".equals(key)) continue;
                        return this.hasReleaseBranches(entry.getValue());
                    }
                }
                return false;
            }

            private boolean hasReleaseBranches(Yaml.Block branchesValue) {
                if (branchesValue instanceof Yaml.Sequence) {
                    Yaml.Sequence sequence = (Yaml.Sequence)branchesValue;
                    for (Yaml.Sequence.Entry entry : sequence.getEntries()) {
                        String branch = YamlHelper.getScalarValue(entry.getBlock());
                        if (branch == null || !RELEASE_BRANCH_PATTERN.matcher(branch).matches()) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean hasPublisherActions(Yaml.Block jobsValue) {
                if (jobsValue instanceof Yaml.Mapping) {
                    Yaml.Mapping jobsMapping = (Yaml.Mapping)jobsValue;
                    for (Yaml.Mapping.Entry jobEntry : jobsMapping.getEntries()) {
                        Yaml.Mapping jobMapping;
                        if (!(jobEntry.getValue() instanceof Yaml.Mapping) || !this.jobHasPublisherAction(jobMapping = (Yaml.Mapping)jobEntry.getValue())) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean jobHasPublisherAction(Yaml.Mapping jobMapping) {
                for (Yaml.Mapping.Entry entry : jobMapping.getEntries()) {
                    if (!(entry.getKey() instanceof Yaml.Scalar) || !"steps".equals(((Yaml.Scalar)entry.getKey()).getValue()) || !(entry.getValue() instanceof Yaml.Sequence)) continue;
                    Yaml.Sequence stepsSequence = (Yaml.Sequence)entry.getValue();
                    for (Yaml.Sequence.Entry stepEntry : stepsSequence.getEntries()) {
                        Yaml.Mapping stepMapping;
                        if (!(stepEntry.getBlock() instanceof Yaml.Mapping) || !this.stepUsesPublisherAction(stepMapping = (Yaml.Mapping)stepEntry.getBlock())) continue;
                        return true;
                    }
                }
                return false;
            }

            private boolean stepUsesPublisherAction(Yaml.Mapping stepMapping) {
                for (Yaml.Mapping.Entry entry : stepMapping.getEntries()) {
                    String uses;
                    if (!"uses".equals(entry.getKey().getValue()) || (uses = YamlHelper.getScalarValue(entry.getValue())) == null) continue;
                    String actionName = this.extractActionName(uses);
                    return PUBLISHER_ACTIONS.contains(actionName);
                }
                return false;
            }

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml.Mapping.Entry mappingEntry = super.visitMappingEntry(entry, (Object)ctx);
                if (this.isCacheAwareActionStep(mappingEntry)) {
                    String actionName = this.getActionName(mappingEntry);
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)mappingEntry, (String)String.format("Action '%s' uses caching in a workflow that publishes artifacts. This could lead to cache poisoning where malicious content gets cached and included in published artifacts. Consider disabling caching for this step or using read-only cache mode.", actionName));
                }
                return mappingEntry;
            }

            private boolean isCacheAwareActionStep(Yaml.Mapping.Entry entry) {
                if (!"uses".equals(entry.getKey().getValue())) {
                    return false;
                }
                String uses = YamlHelper.getScalarValue(entry.getValue());
                if (uses == null) {
                    return false;
                }
                String actionName = this.extractActionName(uses);
                return CACHE_AWARE_ACTIONS.contains(actionName);
            }

            private String getActionName(Yaml.Mapping.Entry entry) {
                String uses = YamlHelper.getScalarValue(entry.getValue());
                return uses != null ? this.extractActionName(uses) : "unknown";
            }

            private String extractActionName(String uses) {
                if (uses.contains("@")) {
                    uses = uses.substring(0, uses.indexOf("@"));
                }
                return uses;
            }
        });
    }

    @Generated
    public CachePoisoningRecipe() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "CachePoisoningRecipe(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CachePoisoningRecipe)) {
            return false;
        }
        CachePoisoningRecipe other = (CachePoisoningRecipe)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CachePoisoningRecipe;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

