/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.github.SetupJavaDistributionReplacerVisitor;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.tree.Yaml;

public class PreferTemurinDistributions
extends Recipe {
    final String displayName = "Use `actions/setup-java` `temurin` distribution as they are cached in hosted runners";
    final String description = "[Host runners](https://docs.github.com/en/actions/using-github-hosted-runners/about-github-hosted-runners#supported-runners-and-hardware-resources/) include Temurin by default as part of the [hosted tool cache](https://github.com/actions/setup-java/blob/main/docs/advanced-usage.md#hosted-tool-cache). Using Temurin speeds up builds as there is no need to download and configure the Java SDK with every build.";
    final Duration estimatedEffortPerOccurrence = Duration.ofMinutes(1L);
    private static final Pattern pattern = Pattern.compile("^(windows|ubuntu|macos)-(latest|\\d+(\\.\\d+)?)$");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new UseTemurinVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public Duration getEstimatedEffortPerOccurrence() {
        return this.estimatedEffortPerOccurrence;
    }

    private static class UseTemurinVisitor
    extends YamlIsoVisitor<ExecutionContext> {
        private List<String> runsOn = new ArrayList<String>();

        private UseTemurinVisitor() {
        }

        public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
            if ("runs-on".equals(entry.getKey().getValue())) {
                this.runsOn = new ArrayList<String>();
                if (entry.getValue() instanceof Yaml.Sequence) {
                    Yaml.Sequence sequence = (Yaml.Sequence)entry.getValue();
                    for (Yaml.Sequence.Entry e2 : sequence.getEntries()) {
                        this.runsOn.add(((Yaml.Scalar)e2.getBlock()).getValue());
                    }
                } else if (entry.getValue() instanceof Yaml.Scalar) {
                    this.runsOn.add(((Yaml.Scalar)entry.getValue()).getValue());
                }
                return super.visitMappingEntry(entry, (Object)ctx);
            }
            int hostedRunnersCount = Math.toIntExact(this.runsOn.stream().filter(e -> pattern.matcher((CharSequence)e).matches()).count());
            if (hostedRunnersCount == this.runsOn.size() && SetupJavaDistributionReplacerVisitor.DISTRIBUTION_MATCHER.matches(this.getCursor()) && !"temurin".equals(((Yaml.Scalar)entry.getValue()).getValue())) {
                return super.visitMappingEntry(entry.withValue((Yaml.Block)((Yaml.Scalar)entry.getValue()).withValue("temurin")), (Object)ctx);
            }
            return super.visitMappingEntry(entry, (Object)ctx);
        }
    }
}

