/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.marker.SearchResult;
import org.openrewrite.yaml.JsonPathMatcher;
import org.openrewrite.yaml.YamlIsoVisitor;
import org.openrewrite.yaml.search.FindKey;
import org.openrewrite.yaml.tree.Yaml;

public class FindMissingTimeout
extends Recipe {
    final String displayName = "Find jobs missing timeout";
    final String description = "Find GitHub Actions jobs missing a timeout.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new YamlIsoVisitor<ExecutionContext>(){

            public Yaml.Mapping.Entry visitMappingEntry(Yaml.Mapping.Entry entry, ExecutionContext ctx) {
                Yaml.Mapping.Entry job = super.visitMappingEntry(entry, (Object)ctx);
                if (new JsonPathMatcher("$.jobs.*.*").matches(this.getCursor()) && FindKey.find((Yaml)job, (String)"$..timeout-minutes").isEmpty()) {
                    return (Yaml.Mapping.Entry)SearchResult.found((Tree)job, (String)"missing: $.jobs.*.timeout-minutes");
                }
                return job;
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

