/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.github.IsGitHubActionsWorkflow;
import org.openrewrite.yaml.ChangeValue;

public final class ChangeAction
extends Recipe {
    @Option(displayName="Action", description="Name of the action to match.", example="gradle/wrapper-validation-action")
    private final String oldAction;
    @Option(displayName="Action", description="Name of the action to use instead.", example="gradle/actions/wrapper-validation")
    private final String newAction;
    @Option(displayName="Version", description="New version to use.", example="v3")
    private final String newVersion;
    private final String displayName = "Change GitHub Action";
    private final String description = "Change a GitHub Action in any workflow.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((Recipe)new IsGitHubActionsWorkflow(), (TreeVisitor)new ChangeValue("$.jobs..[?(@.uses =~ '" + this.oldAction + "(?:@.+)?')].uses", this.newAction + '@' + this.newVersion, null).getVisitor());
    }

    @Generated
    public ChangeAction(String oldAction, String newAction, String newVersion) {
        this.oldAction = oldAction;
        this.newAction = newAction;
        this.newVersion = newVersion;
    }

    @Generated
    public String getOldAction() {
        return this.oldAction;
    }

    @Generated
    public String getNewAction() {
        return this.newAction;
    }

    @Generated
    public String getNewVersion() {
        return this.newVersion;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "ChangeAction(oldAction=" + this.getOldAction() + ", newAction=" + this.getNewAction() + ", newVersion=" + this.getNewVersion() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ChangeAction)) {
            return false;
        }
        ChangeAction other = (ChangeAction)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$oldAction = this.getOldAction();
        String other$oldAction = other.getOldAction();
        if (this$oldAction == null ? other$oldAction != null : !this$oldAction.equals(other$oldAction)) {
            return false;
        }
        String this$newAction = this.getNewAction();
        String other$newAction = other.getNewAction();
        if (this$newAction == null ? other$newAction != null : !this$newAction.equals(other$newAction)) {
            return false;
        }
        String this$newVersion = this.getNewVersion();
        String other$newVersion = other.getNewVersion();
        if (this$newVersion == null ? other$newVersion != null : !this$newVersion.equals(other$newVersion)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ChangeAction;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $oldAction = this.getOldAction();
        result = result * 59 + ($oldAction == null ? 43 : $oldAction.hashCode());
        String $newAction = this.getNewAction();
        result = result * 59 + ($newAction == null ? 43 : $newAction.hashCode());
        String $newVersion = this.getNewVersion();
        result = result * 59 + ($newVersion == null ? 43 : $newVersion.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

