/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.github;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import org.jetbrains.annotations.VisibleForTesting;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.FindSourceFiles;
import org.openrewrite.Option;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.internal.StringUtils;
import org.openrewrite.yaml.MergeYaml;

public class AddCronTrigger
extends Recipe {
    @Option(displayName="Cron expression", description="Using the [POSIX cron syntax](https://pubs.opengroup.org/onlinepubs/9699919799/utilities/crontab.html#tag_20_25_07) or the non standard options @hourly @daily @weekly @weekdays @weekends @monthly @yearly.", example="@daily")
    private final String cron;
    @Option(displayName="Workflow files to match", description="Matches one or more workflows to update. Defaults to `*.{yml,yaml}`", required=false, example="build.yml")
    private final @Nullable String workflowFileMatcher;
    @VisibleForTesting
    transient Random random;
    final String displayName = "Add cron workflow trigger";
    final String description = "The `schedule` [event](https://docs.github.com/en/actions/reference/events-that-trigger-workflows#scheduled-events) allows you to trigger a workflow at a scheduled time.";

    @VisibleForTesting
    AddCronTrigger(String cron, @Nullable String workflowFileMatcher, Random random) {
        this.random = random;
        this.cron = cron;
        this.workflowFileMatcher = workflowFileMatcher;
    }

    public AddCronTrigger(String cron, @Nullable String fileMatcher) {
        this(cron, fileMatcher, ThreadLocalRandom.current());
    }

    private String parseExpression(String cron) {
        RandomCronExpression randomCronExpression = new RandomCronExpression(this.random);
        switch (cron) {
            case "@hourly": {
                return randomCronExpression.hourlyCron();
            }
            case "@daily": {
                return randomCronExpression.dailyCron();
            }
            case "@weekly": {
                return randomCronExpression.weeklyCron();
            }
            case "@weekdays": {
                return randomCronExpression.weekdays();
            }
            case "@weekends": {
                return randomCronExpression.weekends();
            }
            case "@monthly": {
                return randomCronExpression.monthlyCron();
            }
            case "@yearly": {
                return randomCronExpression.yearlyCron();
            }
        }
        return cron;
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        String expression = this.parseExpression(this.cron);
        String path = StringUtils.isBlank((String)this.workflowFileMatcher) ? ".github/workflows/*.{yml,yaml}" : ".github/workflows/" + this.workflowFileMatcher;
        return Preconditions.check((Recipe)new FindSourceFiles(path), (TreeVisitor)new MergeYaml("$.on", String.format("schedule:%n  - cron: \"%s\"", expression), Boolean.valueOf(true), null, null, null, null, null).getVisitor());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddCronTrigger)) {
            return false;
        }
        AddCronTrigger other = (AddCronTrigger)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$cron = this.getCron();
        String other$cron = other.getCron();
        if (this$cron == null ? other$cron != null : !this$cron.equals(other$cron)) {
            return false;
        }
        String this$workflowFileMatcher = this.getWorkflowFileMatcher();
        String other$workflowFileMatcher = other.getWorkflowFileMatcher();
        if (this$workflowFileMatcher == null ? other$workflowFileMatcher != null : !this$workflowFileMatcher.equals(other$workflowFileMatcher)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AddCronTrigger;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $cron = this.getCron();
        result = result * 59 + ($cron == null ? 43 : $cron.hashCode());
        String $workflowFileMatcher = this.getWorkflowFileMatcher();
        result = result * 59 + ($workflowFileMatcher == null ? 43 : $workflowFileMatcher.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    @Generated
    public String getCron() {
        return this.cron;
    }

    @Generated
    public @Nullable String getWorkflowFileMatcher() {
        return this.workflowFileMatcher;
    }

    @Generated
    public Random getRandom() {
        return this.random;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    static class RandomCronExpression {
        private final Random random;

        public RandomCronExpression(Random random) {
            this.random = random;
        }

        public int random(int min, int max) {
            return this.random.nextInt(max + 1 - min) + min;
        }

        public int minute() {
            return this.random(0, 59);
        }

        public int hour() {
            return this.random(0, 23);
        }

        public String dayOfWeek() {
            List<String> daysOfWeek = Arrays.asList("mon", "tue", "wed", "thu", "fri", "sat", "sun");
            return daysOfWeek.get(this.random.nextInt(daysOfWeek.size()));
        }

        public String dailyCron() {
            return String.format("%d %d * * *", this.minute(), this.hour());
        }

        public String weeklyCron() {
            return String.format("%d %d * * %s", this.minute(), this.hour(), this.dayOfWeek());
        }

        public String weekdays() {
            return String.format("%d %d * * 1-5", this.minute(), this.hour());
        }

        public String weekends() {
            return String.format("%d %d * * sat,sun", this.minute(), this.hour());
        }

        public String monthlyCron() {
            return String.format("%d %d %d * *", this.minute(), this.hour(), this.dayOfTheMonth());
        }

        public int dayOfTheMonth() {
            return this.random(1, 28);
        }

        public String month() {
            List<String> months = Arrays.asList("jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec");
            return months.get(this.random.nextInt(months.size()));
        }

        public String hourlyCron() {
            return String.format("* %s * * *", this.hour());
        }

        public String yearlyCron() {
            return String.format("%d %d %d %s *", this.minute(), this.hour(), this.dayOfTheMonth(), this.month());
        }
    }
}

