/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.poi;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public class ReplaceSetBoldweightWithSetBold
extends Recipe {
    final String displayName = "Replace `Font.setBoldweight(short)` with `Font.setBold(boolean)`";
    final String description = "Replace `Font.setBoldweight(short)` or equivalent with `Font.setBold(boolean)`.";
    private static final MethodMatcher SET_BOLDWEIGHT = new MethodMatcher("org.apache.poi.ss.usermodel.Font setBoldweight(short)");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(SET_BOLDWEIGHT), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (!SET_BOLDWEIGHT.matches((MethodCall)m) || m.getSelect() == null) {
                    return m;
                }
                if (this.isBoldweightNormal(m, ctx)) {
                    m = (J.MethodInvocation)JavaTemplate.builder((String)"#{font:any(org.apache.poi.ss.usermodel.Font)}.setBold(false)").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{m.getSelect()});
                } else if (this.isBoldweightBold(m, ctx)) {
                    m = (J.MethodInvocation)JavaTemplate.builder((String)"#{font:any(org.apache.poi.ss.usermodel.Font)}.setBold(true)").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"poi"})).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{m.getSelect()});
                }
                return m;
            }

            private boolean isBoldweightNormal(J.MethodInvocation method, ExecutionContext ctx) {
                final AtomicBoolean found = new AtomicBoolean(false);
                new JavaIsoVisitor<ExecutionContext>(){

                    public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                        if (Objects.equals(400, literal.getValue())) {
                            found.set(true);
                        }
                        return super.visitLiteral(literal, (Object)ctx);
                    }

                    public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                        if ("BOLDWEIGHT_NORMAL".equals(identifier.getSimpleName())) {
                            found.set(true);
                        }
                        return super.visitIdentifier(identifier, (Object)ctx);
                    }
                }.visit((Tree)method, (Object)ctx);
                return found.get();
            }

            private boolean isBoldweightBold(J.MethodInvocation method, ExecutionContext ctx) {
                final AtomicBoolean found = new AtomicBoolean(false);
                new JavaIsoVisitor<ExecutionContext>(){

                    public J.Literal visitLiteral(J.Literal literal, ExecutionContext ctx) {
                        if (Objects.equals(700, literal.getValue())) {
                            found.set(true);
                        }
                        return super.visitLiteral(literal, (Object)ctx);
                    }

                    public J.Identifier visitIdentifier(J.Identifier identifier, ExecutionContext ctx) {
                        if ("BOLDWEIGHT_BOLD".equals(identifier.getSimpleName())) {
                            found.set(true);
                        }
                        return super.visitIdentifier(identifier, (Object)ctx);
                    }
                }.visit((Tree)method, (Object)ctx);
                return found.get();
            }
        });
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }
}

