/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.httpclient5;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class RemoveByteBufferAllocators
extends Recipe {
    private static final String dbbaClassName = "org.apache.http.nio.util.DirectByteBufferAllocator";
    private static final String dbbaAllocatePattern = "org.apache.http.nio.util.DirectByteBufferAllocator allocate(int)";
    private static final MethodMatcher dbbaAllocateMatcher = new MethodMatcher("org.apache.http.nio.util.DirectByteBufferAllocator allocate(int)");
    private static final String hbbaClassName = "org.apache.http.nio.util.HeapByteBufferAllocator";
    private static final String hbbaAllocatePattern = "org.apache.http.nio.util.HeapByteBufferAllocator allocate(int)";
    private static final MethodMatcher hbbaAllocateMatcher = new MethodMatcher("org.apache.http.nio.util.HeapByteBufferAllocator allocate(int)");
    private final String displayName = "Remove ByteBufferAllocator implementations";
    private final String description = "In Apache Http Client 5.x migration, both implementations of `ByteBufferAllocator` have been removed. This recipe will remove usage of said classes in favour of direct static calls to `ByteBuffer`.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesMethod(dbbaAllocatePattern), new UsesMethod(hbbaAllocatePattern)}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (dbbaAllocateMatcher.matches((MethodCall)m)) {
                    this.maybeRemoveImport(RemoveByteBufferAllocators.dbbaClassName);
                    this.maybeAddImport("java.nio.ByteBuffer");
                    return (J.MethodInvocation)JavaTemplate.builder((String)"ByteBuffer.allocateDirect(#{any(int)})").imports(new String[]{"java.nio.ByteBuffer"}).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{m.getArguments().get(0)});
                }
                if (hbbaAllocateMatcher.matches((MethodCall)m)) {
                    this.maybeRemoveImport(RemoveByteBufferAllocators.hbbaClassName);
                    this.maybeAddImport("java.nio.ByteBuffer");
                    return (J.MethodInvocation)JavaTemplate.builder((String)"ByteBuffer.allocate(#{any(int)})").imports(new String[]{"java.nio.ByteBuffer"}).build().apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{m.getArguments().get(0)});
                }
                return m;
            }
        });
    }

    @Generated
    public RemoveByteBufferAllocators() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "RemoveByteBufferAllocators(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RemoveByteBufferAllocators)) {
            return false;
        }
        RemoveByteBufferAllocators other = (RemoveByteBufferAllocators)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RemoveByteBufferAllocators;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

