/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.httpclient5;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class NewStatusLine
extends Recipe {
    private final String displayName = "Replaces deprecated `HttpResponse::getStatusLine()`";
    private final String description = "`HttpResponse::getStatusLine()` was deprecated in 4.x, so we replace it for `new StatusLine(HttpResponse)`. Ideally we will try to simplify method chains for `getStatusCode`, `getProtocolVersion` and `getReasonPhrase`, but there are some scenarios where the `StatusLine` object is assigned or used directly, and we need to instantiate the object.";
    private static final MethodMatcher MATCHER = new MethodMatcher("org.apache.http.HttpResponse getStatusLine()");

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(MATCHER), (TreeVisitor)new JavaVisitor<ExecutionContext>(){

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (MATCHER.matches((MethodCall)m)) {
                    this.maybeAddImport("org.apache.hc.core5.http.message.StatusLine");
                    return JavaTemplate.builder((String)"new StatusLine(#{any(org.apache.hc.core5.http.HttpResponse)})").imports(new String[]{"org.apache.hc.core5.http.message.StatusLine"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"httpcore5"})).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replace(), new Object[]{m.getSelect()});
                }
                return m;
            }
        });
    }

    @Generated
    public NewStatusLine() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "NewStatusLine(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewStatusLine)) {
            return false;
        }
        NewStatusLine other = (NewStatusLine)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NewStatusLine;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

