/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.httpclient5;

import java.util.Objects;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesType;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;

public final class MigrateSSLConnectionSocketFactory
extends Recipe {
    private static final String HTTPCLIENT_4_SSL_CONNECTION_SOCKET_FACTORY = "org.apache.http.conn.ssl.SSLConnectionSocketFactory";
    private static final String HTTPCLIENT_5_SSL_CONNECTION_SOCKET_FACTORY = "org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory";
    private static final String DEFAULT_TLS_SOCKET_STRATEGY = "org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy";
    private static final String TLS_SOCKET_STRATEGY = "org.apache.hc.client5.http.ssl.TlsSocketStrategy";
    private static final MethodMatcher SET_SSL_SOCKET_FACTORY = new MethodMatcher("org.apache..*..HttpClientBuilder setSSLSocketFactory(..)");
    private final String displayName = "Migrate deprecated `SSLConnectionSocketFactory` to `DefaultClientTlsStrategy`";
    private final String description = "Migrates usage of the deprecated `org.apache.http.conn.ssl.SSLConnectionSocketFactory` to `org.apache.hc.client5.http.ssl.DefaultClientTlsStrategy` with proper connection manager setup.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.or((TreeVisitor[])new TreeVisitor[]{new UsesType(HTTPCLIENT_4_SSL_CONNECTION_SOCKET_FACTORY, Boolean.valueOf(false)), new UsesType(HTTPCLIENT_5_SSL_CONNECTION_SOCKET_FACTORY, Boolean.valueOf(false))}), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.CompilationUnit visitCompilationUnit(J.CompilationUnit cu, ExecutionContext ctx) {
                cu = (J.CompilationUnit)new TransformSSLConnectionSocketFactoryVisitor().visitNonNull((Tree)cu, ctx);
                cu = (J.CompilationUnit)new AddConnectionManagerVisitor().visitNonNull((Tree)cu, ctx);
                return (J.CompilationUnit)new TransformSetSSLSocketFactoryVisitor().visitNonNull((Tree)cu, ctx);
            }
        });
    }

    @Generated
    public MigrateSSLConnectionSocketFactory() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "MigrateSSLConnectionSocketFactory(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MigrateSSLConnectionSocketFactory)) {
            return false;
        }
        MigrateSSLConnectionSocketFactory other = (MigrateSSLConnectionSocketFactory)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof MigrateSSLConnectionSocketFactory;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    private static class TransformSetSSLSocketFactoryVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private TransformSetSSLSocketFactoryVisitor() {
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.Identifier arg;
            J.MethodInvocation mi = super.visitMethodInvocation(method, (Object)ctx);
            if (SET_SSL_SOCKET_FACTORY.matches((MethodCall)mi) && mi.getArguments().size() == 1 && mi.getArguments().get(0) instanceof J.Identifier && (arg = (J.Identifier)mi.getArguments().get(0)).getType() != null && (TypeUtils.isOfClassType((JavaType)arg.getType(), (String)MigrateSSLConnectionSocketFactory.HTTPCLIENT_4_SSL_CONNECTION_SOCKET_FACTORY) || TypeUtils.isOfClassType((JavaType)arg.getType(), (String)MigrateSSLConnectionSocketFactory.HTTPCLIENT_5_SSL_CONNECTION_SOCKET_FACTORY))) {
                this.maybeRemoveImport(MigrateSSLConnectionSocketFactory.HTTPCLIENT_4_SSL_CONNECTION_SOCKET_FACTORY);
                this.maybeRemoveImport(MigrateSSLConnectionSocketFactory.HTTPCLIENT_5_SSL_CONNECTION_SOCKET_FACTORY);
                return (J.MethodInvocation)JavaTemplate.builder((String)"#{any()}.setConnectionManager(cm)").contextSensitive().javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"httpclient5", "httpcore5"})).build().apply(this.getCursor(), mi.getCoordinates().replace(), new Object[]{mi.getSelect()});
            }
            return mi;
        }
    }

    private static class AddConnectionManagerVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private static final String HTTP_CLIENT_CONNECTION_MANAGER = "org.apache.hc.client5.http.io.HttpClientConnectionManager";
        private static final String POOLING_HTTP_CLIENT_CONNECTION_MANAGER_BUILDER = "org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder";

        private AddConnectionManagerVisitor() {
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            J.MethodDeclaration m = super.visitMethodDeclaration(method, (Object)ctx);
            if (m.getBody() == null) {
                return m;
            }
            class MethodAnalyzer
            extends JavaIsoVisitor<ExecutionContext> {
                boolean connectionManagerExists;
                boolean hasSetSSLSocketFactory;
                // Could not load outer class - annotation placement on inner may be incorrect
                 @Nullable J.VariableDeclarations tlsStrategyDecl;

                MethodAnalyzer() {
                }

                public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations vd, ExecutionContext ctx) {
                    if (!vd.getVariables().isEmpty()) {
                        if (TypeUtils.isOfClassType((JavaType)vd.getType(), (String)MigrateSSLConnectionSocketFactory.TLS_SOCKET_STRATEGY)) {
                            this.tlsStrategyDecl = vd;
                        } else if (TypeUtils.isOfClassType((JavaType)((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getType(), (String)AddConnectionManagerVisitor.HTTP_CLIENT_CONNECTION_MANAGER)) {
                            this.connectionManagerExists = true;
                        }
                    }
                    return super.visitVariableDeclarations(vd, (Object)ctx);
                }

                public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                    if (SET_SSL_SOCKET_FACTORY.matches((MethodCall)method)) {
                        this.hasSetSSLSocketFactory = true;
                    }
                    return super.visitMethodInvocation(method, (Object)ctx);
                }

                boolean shouldAddConnectionManager() {
                    return this.tlsStrategyDecl != null && this.hasSetSSLSocketFactory && !this.connectionManagerExists;
                }
            }
            MethodAnalyzer analyzer = new MethodAnalyzer();
            analyzer.visit((Tree)m.getBody(), ctx);
            if (analyzer.shouldAddConnectionManager()) {
                J.Identifier tlsStrategyIdentifier = ((J.VariableDeclarations.NamedVariable)analyzer.tlsStrategyDecl.getVariables().get(0)).getName();
                String httpClientConnectionManagerCode = "HttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setTlsSocketStrategy(#{any(org.apache.hc.client5.http.ssl.TlsSocketStrategy)}).build();";
                this.maybeAddImport(HTTP_CLIENT_CONNECTION_MANAGER);
                this.maybeAddImport(POOLING_HTTP_CLIENT_CONNECTION_MANAGER_BUILDER);
                return (J.MethodDeclaration)JavaTemplate.builder((String)httpClientConnectionManagerCode).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"httpclient5", "httpcore5"})).imports(new String[]{HTTP_CLIENT_CONNECTION_MANAGER, POOLING_HTTP_CLIENT_CONNECTION_MANAGER_BUILDER}).build().apply(this.updateCursor((Tree)m), analyzer.tlsStrategyDecl.getCoordinates().after(), new Object[]{tlsStrategyIdentifier});
            }
            return m;
        }
    }

    private static class TransformSSLConnectionSocketFactoryVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private TransformSSLConnectionSocketFactoryVisitor() {
        }

        public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, ExecutionContext ctx) {
            J.VariableDeclarations vd = super.visitVariableDeclarations(multiVariable, (Object)ctx);
            if ((TypeUtils.isOfClassType((JavaType)vd.getType(), (String)MigrateSSLConnectionSocketFactory.HTTPCLIENT_4_SSL_CONNECTION_SOCKET_FACTORY) || TypeUtils.isOfClassType((JavaType)vd.getType(), (String)MigrateSSLConnectionSocketFactory.HTTPCLIENT_5_SSL_CONNECTION_SOCKET_FACTORY)) && !vd.getVariables().isEmpty() && ((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer() instanceof J.NewClass) {
                boolean hasExactlyOneArgument;
                J.NewClass newClass = Objects.requireNonNull((J.NewClass)((J.VariableDeclarations.NamedVariable)vd.getVariables().get(0)).getInitializer());
                boolean bl = hasExactlyOneArgument = !newClass.getArguments().isEmpty() && newClass.getArguments().size() == 1 && newClass.getArguments().get(0) instanceof J.Identifier;
                if (hasExactlyOneArgument) {
                    String code = "TlsSocketStrategy tlsSocketStrategy = new DefaultClientTlsStrategy(#{any(javax.net.ssl.SSLContext)})";
                    this.maybeRemoveImport(MigrateSSLConnectionSocketFactory.HTTPCLIENT_4_SSL_CONNECTION_SOCKET_FACTORY);
                    this.maybeRemoveImport(MigrateSSLConnectionSocketFactory.HTTPCLIENT_5_SSL_CONNECTION_SOCKET_FACTORY);
                    this.maybeAddImport(MigrateSSLConnectionSocketFactory.TLS_SOCKET_STRATEGY);
                    this.maybeAddImport(MigrateSSLConnectionSocketFactory.DEFAULT_TLS_SOCKET_STRATEGY);
                    return (J.VariableDeclarations)JavaTemplate.builder((String)code).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"httpclient5", "httpcore5"})).imports(new String[]{MigrateSSLConnectionSocketFactory.TLS_SOCKET_STRATEGY, MigrateSSLConnectionSocketFactory.DEFAULT_TLS_SOCKET_STRATEGY}).build().apply(this.getCursor(), vd.getCoordinates().replace(), new Object[]{newClass.getArguments().get(0)});
                }
            }
            return vd;
        }
    }
}

