/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.httpclient5;

import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.jspecify.annotations.Nullable;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.RemoveMethodInvocationsVisitor;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.trait.MethodAccess;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TypeUtils;
import org.openrewrite.marker.SearchResult;

public class MigrateRequestConfig
extends Recipe {
    private static final String FQN_REQUEST_CONFIG = "org.apache.http.client.config.RequestConfig";
    private static final String FQN_REQUEST_CONFIG_BUILDER = "org.apache.http.client.config.RequestConfig.Builder";
    private static final String FQN_POOL_CONN_MANAGER4 = "org.apache.http.impl.conn.PoolingHttpClientConnectionManager";
    private static final String FQN_POOL_CONN_MANAGER5 = "org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager";
    private static final String FQN_HTTP_CLIENT_BUILDER = "org.apache.http.impl.client.HttpClientBuilder";
    private static final String FQN_TIME_VALUE = "org.apache.hc.core5.util.TimeValue";
    private static final String PATTERN_STALE_CHECK_ENABLED = "org.apache.http.client.config.RequestConfig.Builder setStaleConnectionCheckEnabled(..)";
    private static final String PATTERN_REQUEST_CONFIG = "org.apache.http.impl.client.HttpClientBuilder setDefaultRequestConfig(..)";
    private static final MethodMatcher MATCHER_STALE_CHECK_ENABLED = new MethodMatcher("org.apache.http.client.config.RequestConfig.Builder setStaleConnectionCheckEnabled(..)", false);
    private static final MethodMatcher MATCHER_REQUEST_CONFIG = new MethodMatcher("org.apache.http.impl.client.HttpClientBuilder setDefaultRequestConfig(..)", false);
    private static final String KEY_POOL_CONN_MANAGER = "poolConnManager";
    final String displayName = "Migrate `RequestConfig` to httpclient5";
    final String description = "Migrate `RequestConfig` to httpclient5.";

    private static TreeVisitor<? extends Tree, ExecutionContext> callsSetStaleCheckEnabledFalse() {
        return new MethodAccess.Matcher(MATCHER_STALE_CHECK_ENABLED).asVisitor(access -> J.Literal.isLiteralValue((Expression)((Expression)((MethodCall)access.getTree()).getArguments().get(0)), (Object)false) ? SearchResult.found((Tree)((MethodCall)access.getTree())) : access.getTree());
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)Preconditions.and((TreeVisitor[])new TreeVisitor[]{new UsesMethod(MATCHER_STALE_CHECK_ENABLED), MigrateRequestConfig.callsSetStaleCheckEnabledFalse()}), (TreeVisitor)new MigrateRequestConfigVisitor());
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    private static class MigrateRequestConfigVisitor
    extends JavaIsoVisitor<ExecutionContext> {
        private MigrateRequestConfigVisitor() {
        }

        public J.MethodDeclaration visitMethodDeclaration(J.MethodDeclaration method, ExecutionContext ctx) {
            boolean staleEnabled;
            boolean bl = staleEnabled = MigrateRequestConfig.callsSetStaleCheckEnabledFalse().visitNonNull((Tree)method, (Object)ctx, this.getCursor().getParentOrThrow()) != method;
            if (staleEnabled) {
                boolean needsNewConnectionManager;
                J.VariableDeclarations connectionManagerVD = this.findExistingConnectionPool(method);
                boolean bl2 = needsNewConnectionManager = connectionManagerVD == null;
                if (needsNewConnectionManager) {
                    this.maybeAddImport(MigrateRequestConfig.FQN_POOL_CONN_MANAGER5);
                    method = (J.MethodDeclaration)JavaTemplate.builder((String)"PoolingHttpClientConnectionManager poolingHttpClientConnectionManager = new PoolingHttpClientConnectionManager();").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"httpclient5", "httpcore5"})).imports(new String[]{MigrateRequestConfig.FQN_POOL_CONN_MANAGER5}).build().apply(this.getCursor(), method.getBody().getCoordinates().firstStatement(), new Object[0]);
                    connectionManagerVD = (J.VariableDeclarations)method.getBody().getStatements().get(0);
                }
                J.Identifier connectionManagerIdentifier = ((J.VariableDeclarations.NamedVariable)connectionManagerVD.getVariables().get(0)).getName();
                this.maybeAddImport(MigrateRequestConfig.FQN_TIME_VALUE);
                method = (J.MethodDeclaration)JavaTemplate.builder((String)"#{any(org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager)}.setValidateAfterInactivity(TimeValue.NEG_ONE_MILLISECOND);").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"httpclient5", "httpcore5"})).imports(new String[]{MigrateRequestConfig.FQN_TIME_VALUE}).build().apply(this.updateCursor((Tree)method), connectionManagerVD.getCoordinates().after(), new Object[]{connectionManagerIdentifier});
                if (needsNewConnectionManager) {
                    this.getCursor().putMessage(MigrateRequestConfig.KEY_POOL_CONN_MANAGER, (Object)connectionManagerIdentifier);
                }
            }
            return super.visitMethodDeclaration(method, (Object)ctx);
        }

        private // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable J.VariableDeclarations findExistingConnectionPool(J.MethodDeclaration method) {
            AtomicReference existingConnManager = new AtomicReference();
            new JavaIsoVisitor<AtomicReference<J.VariableDeclarations>>(){

                public J.VariableDeclarations visitVariableDeclarations(J.VariableDeclarations multiVariable, AtomicReference<J.VariableDeclarations> ref) {
                    J.VariableDeclarations vd = super.visitVariableDeclarations(multiVariable, ref);
                    if (TypeUtils.isOfClassType((JavaType)vd.getTypeAsFullyQualified(), (String)MigrateRequestConfig.FQN_POOL_CONN_MANAGER4)) {
                        ref.set(vd);
                    }
                    return vd;
                }
            }.visitNonNull((Tree)method, existingConnManager, this.getCursor().getParentOrThrow());
            return (J.VariableDeclarations)existingConnManager.get();
        }

        public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
            J.Identifier connectionManagerIdentifier;
            if (MATCHER_STALE_CHECK_ENABLED.matches((MethodCall)method)) {
                this.doAfterVisit((TreeVisitor)new RemoveMethodInvocationsVisitor(Collections.singletonList(MigrateRequestConfig.PATTERN_STALE_CHECK_ENABLED)));
            } else if (MATCHER_REQUEST_CONFIG.matches((MethodCall)method) && (connectionManagerIdentifier = (J.Identifier)this.getCursor().pollNearestMessage(MigrateRequestConfig.KEY_POOL_CONN_MANAGER)) != null) {
                method = (J.MethodInvocation)JavaTemplate.builder((String)"#{any()}.setConnectionManager(#{any()});").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"httpclient5", "httpcore5"})).imports(new String[]{MigrateRequestConfig.FQN_POOL_CONN_MANAGER5}).build().apply(this.getCursor(), method.getCoordinates().replace(), new Object[]{method, connectionManagerIdentifier});
            }
            return super.visitMethodInvocation(method, (Object)ctx);
        }
    }
}

