/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.httpclient5;

import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Preconditions;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.apache.httpclient5.NonRepeatableByteArrayArgumentMatcher;
import org.openrewrite.apache.httpclient5.RepeatableByteArrayArgumentMatcher;
import org.openrewrite.internal.ListUtils;
import org.openrewrite.java.JavaIsoVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.search.UsesMethod;
import org.openrewrite.java.tree.Expression;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;
import org.openrewrite.java.tree.TextComment;
import org.openrewrite.marker.Markers;

public final class InputBufferReadAddOffsetAndLengthArguments
extends Recipe {
    private static final String READ_PATTERN = "org.apache.hc.core5.http.nio.support.classic.SharedInputBuffer read(byte[])";
    private static final MethodMatcher READ_MATCHER = new MethodMatcher("org.apache.hc.core5.http.nio.support.classic.SharedInputBuffer read(byte[])");
    private final String displayName = "Adds offset and length arguments to the read method of SharedInputBuffer";
    private final String description = "In Apache Http Client 5.x migration, the shortened form of the `read(byte[])` has been removed.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return Preconditions.check((TreeVisitor)new UsesMethod(READ_PATTERN), (TreeVisitor)new JavaIsoVisitor<ExecutionContext>(){

            public J.MethodInvocation visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = super.visitMethodInvocation(method, (Object)ctx);
                if (READ_MATCHER.matches((MethodCall)m)) {
                    Expression firstArg = (Expression)m.getArguments().get(0);
                    JavaTemplate after = JavaTemplate.builder((String)"#{any(org.apache.hc.core5.http.nio.support.classic.SharedInputBuffer)}.read(#{any(byte[])}, 0, #{any(byte[])}.length)").javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"httpcore5"})).build();
                    if (new RepeatableByteArrayArgumentMatcher().matches(firstArg)) {
                        return (J.MethodInvocation)after.apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{Objects.requireNonNull(m.getSelect()), firstArg, firstArg});
                    }
                    if (new NonRepeatableByteArrayArgumentMatcher().matches(firstArg)) {
                        return (J.MethodInvocation)after.apply(this.getCursor(), m.getCoordinates().replace(), new Object[]{Objects.requireNonNull(m.getSelect()), firstArg, firstArg}).withComments(ListUtils.concat((List)m.getComments(), (Object)new TextComment(true, " TODO: Please check that repeated obtaining of byte[] is safe here ", m.getPrefix().getWhitespace(), Markers.EMPTY)));
                    }
                }
                return m;
            }
        });
    }

    @Generated
    public InputBufferReadAddOffsetAndLengthArguments() {
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String toString() {
        return "InputBufferReadAddOffsetAndLengthArguments(displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputBufferReadAddOffsetAndLengthArguments)) {
            return false;
        }
        InputBufferReadAddOffsetAndLengthArguments other = (InputBufferReadAddOffsetAndLengthArguments)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof InputBufferReadAddOffsetAndLengthArguments;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

