/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.apache.httpclient5;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Recipe;
import org.openrewrite.Tree;
import org.openrewrite.TreeVisitor;
import org.openrewrite.java.JavaParser;
import org.openrewrite.java.JavaTemplate;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.MethodMatcher;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.MethodCall;

public final class NewStatusLine
extends Recipe {
    public String getDisplayName() {
        return "Replaces deprecated `HttpResponse::getStatusLine()`";
    }

    public String getDescription() {
        return "`HttpResponse::getStatusLine()` was deprecated in 4.x, so we replace it for `new StatusLine(HttpResponse)`. Ideally we will try to simplify method chains for `getStatusCode`, `getProtocolVersion` and `getReasonPhrase`, but there are some scenarios where the `StatusLine` object is assigned or used directly, and we need to instantiate the object.";
    }

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new JavaVisitor<ExecutionContext>(){
            final MethodMatcher matcher = new MethodMatcher("org.apache.hc.core5.http.HttpResponse getStatusLine()");

            public J visitMethodInvocation(J.MethodInvocation method, ExecutionContext ctx) {
                J.MethodInvocation m = (J.MethodInvocation)super.visitMethodInvocation(method, (Object)ctx);
                if (this.matcher.matches((MethodCall)m)) {
                    this.maybeAddImport("org.apache.hc.core5.http.message.StatusLine");
                    return JavaTemplate.builder((String)"new StatusLine(#{any(org.apache.hc.core5.http.HttpResponse)})").imports(new String[]{"org.apache.hc.core5.http.message.StatusLine"}).javaParser(JavaParser.fromJavaVersion().classpathFromResources(ctx, new String[]{"httpcore5"})).build().apply(this.updateCursor((Tree)m), m.getCoordinates().replace(), new Object[]{m.getSelect()});
                }
                return m;
            }
        };
    }

    @Generated
    public NewStatusLine() {
    }

    @Generated
    public String toString() {
        return "NewStatusLine()";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewStatusLine)) {
            return false;
        }
        NewStatusLine other = (NewStatusLine)((Object)o);
        return other.canEqual((Object)this);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof NewStatusLine;
    }

    @Generated
    public int hashCode() {
        boolean result = true;
        return 1;
    }
}

