/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.trait.expr;

import fj.data.Option;
import fj.data.Validation;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.openrewrite.Cursor;
import org.openrewrite.Tree;
import org.openrewrite.analysis.trait.Top;
import org.openrewrite.analysis.trait.expr.Expr;
import org.openrewrite.analysis.trait.expr.FieldFromJavaTypeVariable;
import org.openrewrite.analysis.trait.expr.InstanceAccess;
import org.openrewrite.analysis.trait.expr.VarAccess;
import org.openrewrite.analysis.trait.internal.MaybeParenthesesPair;
import org.openrewrite.analysis.trait.util.TraitErrors;
import org.openrewrite.analysis.trait.variable.Variable;
import org.openrewrite.java.JavaVisitor;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaSourceFile;
import org.openrewrite.java.tree.Javadoc;

class VarAccessBase
extends Top.Base
implements VarAccess {
    private final Cursor cursor;
    private final J.Identifier identifier;
    private final AtomicReference<Object> variable = new AtomicReference();

    @Override
    public UUID getId() {
        return this.identifier.getId();
    }

    @Override
    public String getName() {
        return this.identifier.getSimpleName();
    }

    @Override
    public boolean hasQualifier() {
        return this.cursor.getParentTreeCursor().getValue() instanceof J.FieldAccess;
    }

    @Override
    public Option<Expr> getQualifier() {
        return InstanceAccess.viewOf(this.cursor.getParentTreeCursor()).map(Expr.class::cast).toOption();
    }

    @Override
    public boolean isLocal() {
        return true;
    }

    @Override
    public boolean isLValue() {
        MaybeParenthesesPair pair = MaybeParenthesesPair.from(this.cursor);
        if (pair.getParent() instanceof J.Assignment) {
            J.Assignment assignment = (J.Assignment)pair.getParent();
            return assignment.getVariable() == pair.getTree();
        }
        if (pair.getParent() instanceof J.Unary) {
            J.Unary unary = (J.Unary)pair.getParent();
            return unary.getExpression() == pair.getTree();
        }
        return false;
    }

    @Override
    public boolean isRValue() {
        MaybeParenthesesPair pair = MaybeParenthesesPair.from(this.cursor);
        if (pair.getParent() instanceof J.Assignment) {
            J.Assignment assignment = (J.Assignment)pair.getParent();
            return assignment.getVariable() != pair.getTree();
        }
        return true;
    }

    private static Variable computeVariable(final VarAccessBase varAccess, Cursor cursor, final J.Identifier varAccessIdent) {
        Cursor compilationUnit = cursor.dropParentUntil(JavaSourceFile.class::isInstance);
        AtomicBoolean found = new AtomicBoolean(false);
        final Variable[] closestVariable = new Variable[1];
        new JavaVisitor<AtomicBoolean>(){

            public J visitVariable(J.VariableDeclarations.NamedVariable variable, AtomicBoolean atomicBoolean) {
                if (atomicBoolean.get()) {
                    return variable;
                }
                if (variable.getName().getSimpleName().equals(varAccessIdent.getSimpleName())) {
                    assert (varAccess.identifier.getFieldType() != null);
                    assert (varAccess.identifier.getFieldType().getOwner() != null);
                    assert (variable.getName().getFieldType() != null);
                    if (varAccess.identifier.getFieldType().getOwner().equals(variable.getName().getFieldType().getOwner())) {
                        closestVariable[0] = (Variable)Variable.viewOf(this.getCursor()).on(TraitErrors::doThrow);
                    }
                }
                return super.visitVariable(variable, (Object)atomicBoolean);
            }

            public J visitIdentifier(J.Identifier ident, AtomicBoolean atomicBoolean) {
                if (ident == varAccessIdent) {
                    atomicBoolean.set(true);
                }
                return ident;
            }
        }.visit((Tree)compilationUnit.getValue(), (Object)found, compilationUnit.getParentOrThrow());
        if (closestVariable[0] != null) {
            return closestVariable[0];
        }
        if (varAccessIdent.getFieldType() != null) {
            return FieldFromJavaTypeVariable.create(varAccessIdent.getFieldType(), cursor);
        }
        throw new IllegalStateException("Unable to find variable for " + varAccessIdent.getSimpleName());
    }

    static Validation<TraitErrors, VarAccess> viewOf(Cursor cursor, J.Identifier ident) {
        assert (cursor.getValue() == ident);
        if ("this".equals(ident.getSimpleName())) {
            return TraitErrors.invalidTraitCreationError("`this` is not a variable access");
        }
        if ("super".equals(ident.getSimpleName())) {
            return TraitErrors.invalidTraitCreationError("`super` is not a variable access");
        }
        Cursor parent = cursor.getParentTreeCursor();
        if (VarAccessBase.checkType(parent, J.VariableDeclarations.NamedVariable.class, parentNamedVariable -> parentNamedVariable.getName() == ident)) {
            return TraitErrors.invalidTraitCreationError("J.Identifier on the name side of a variable declaration is not a variable access");
        }
        if (ident.getFieldType() != null) {
            return Validation.success((Object)new VarAccessBase(cursor, ident));
        }
        if (VarAccessBase.checkType(parent, J.NewClass.class, parentNewClass -> parentNewClass.getClazz() == ident)) {
            assert (ident.getFieldType() == null);
            return TraitErrors.invalidTraitCreationError("J.Identifier within a new class statement is not a variable access");
        }
        if (VarAccessBase.checkType(parent, J.MethodInvocation.class, parentMethodInvocation -> parentMethodInvocation.getName() == ident)) {
            assert (ident.getFieldType() == null);
            return TraitErrors.invalidTraitCreationError("J.Identifier within a method invocation name is not a variable access");
        }
        if (cursor.firstEnclosing(Javadoc.class) != null) {
            return TraitErrors.invalidTraitCreationError("J.Identifier as an argument in a method call directly only appears in Javadoc comments");
        }
        if (VarAccessBase.checkType(parent, J.MethodDeclaration.class, parentMethodDeclaration -> parentMethodDeclaration.getName() == ident)) {
            assert (ident.getFieldType() == null);
            return TraitErrors.invalidTraitCreationError("J.Identifier within a method declaration name is not a variable access");
        }
        if (VarAccessBase.checkType(parent, J.ControlParentheses.class, parentControlParentheses -> parentControlParentheses.getTree() == ident && VarAccessBase.checkType(parent.getParentTreeCursor(), J.TypeCast.class, parentParentTypeCast -> parentParentTypeCast.getClazz() == parentControlParentheses))) {
            assert (ident.getFieldType() == null);
            return TraitErrors.invalidTraitCreationError("J.Identifier within a type cast class part is not a variable access");
        }
        if (VarAccessBase.checkType(parent, J.Assignment.class, parentAssignment -> parentAssignment.getVariable() == ident && VarAccessBase.checkType(parent.getParentTreeCursor(), J.Annotation.class, parentParentAnnotation -> parentParentAnnotation.getArguments() != null && parentParentAnnotation.getArguments().contains(parentAssignment)))) {
            assert (ident.getFieldType() == null);
            return TraitErrors.invalidTraitCreationError("J.Identifier within an annotation argument's argument label is not a variable access");
        }
        boolean isParentFieldAccess = VarAccessBase.checkType(parent, J.FieldAccess.class, parentFieldAccess -> parentFieldAccess.getName() == ident);
        boolean isParentMethodAccess = VarAccessBase.checkType(parent, J.MethodInvocation.class, parentMethodInvocation -> parentMethodInvocation.getSelect() == ident);
        if (ident.getFieldType() != null && isParentFieldAccess) {
            return Validation.success((Object)new VarAccessBase(cursor, ident));
        }
        if (ident.getFieldType() == null && (isParentFieldAccess || isParentMethodAccess)) {
            return TraitErrors.invalidTraitCreationError("J.Identifier within a field access is not a variable access, or type information is missing.");
        }
        if (VarAccessBase.checkType(parent, J.MethodInvocation.class, parentMethodInvocation -> parentMethodInvocation.getSelect() == ident || parentMethodInvocation.getArguments().contains(ident)) || VarAccessBase.checkType(parent, J.NewClass.class, parentNewClass -> parentNewClass.getEnclosing() == ident || parentNewClass.getArguments().contains(ident)) || VarAccessBase.checkType(parent, J.Parentheses.class, parentParentheses -> parentParentheses.getTree() == ident) || VarAccessBase.checkType(parent, J.Unary.class, parentUnary -> parentUnary.getExpression() == ident) || VarAccessBase.checkType(parent, J.Binary.class, parentBinary -> parentBinary.getLeft() == ident || parentBinary.getRight() == ident) || VarAccessBase.checkType(parent, J.VariableDeclarations.NamedVariable.class, parentNamedVariable -> parentNamedVariable.getInitializer() == ident) || VarAccessBase.checkType(parent, J.Assignment.class, parentAssignment -> parentAssignment.getVariable() == ident || parentAssignment.getAssignment() == ident) || VarAccessBase.checkType(parent, J.TypeCast.class, parentTypeCast -> parentTypeCast.getExpression() == ident) || VarAccessBase.checkType(parent, J.ControlParentheses.class, parentControlParentheses -> parentControlParentheses.getTree() == ident) || VarAccessBase.checkType(parent, J.ForEachLoop.Control.class, parentForEachLoopControl -> parentForEachLoopControl.getIterable() == ident) || VarAccessBase.checkType(parent, J.ForLoop.Control.class, parentForLoopControl -> parentForLoopControl.getCondition() == ident) || VarAccessBase.checkType(parent, J.NewArray.class, parentNewArray -> parentNewArray.getInitializer() != null && parentNewArray.getInitializer().contains(ident)) || VarAccessBase.checkType(parent, J.ArrayDimension.class, parentArrayDimension -> parentArrayDimension.getIndex() == ident) || VarAccessBase.checkType(parent, J.ArrayAccess.class, parentArrayAccess -> parentArrayAccess.getIndexed() == ident) || VarAccessBase.checkType(parent, J.Ternary.class, parentTernary -> parentTernary.getCondition() == ident || parentTernary.getTruePart() == ident || parentTernary.getFalsePart() == ident) || VarAccessBase.checkType(parent, J.Annotation.class, parentAnnotation -> parentAnnotation.getArguments() != null && parentAnnotation.getArguments().contains(ident))) {
            return Validation.success((Object)new VarAccessBase(cursor, ident));
        }
        if (cursor.getPathAsStream(o -> o instanceof J.Import || o instanceof J.Package).findAny().isPresent()) {
            assert (ident.getFieldType() == null);
            return TraitErrors.invalidTraitCreationError("J.Identifier within an import or package statement is not a variable access");
        }
        assert (ident.getFieldType() == null) : "J.Identifier is not a variable access, but probably should be: " + ident;
        return TraitErrors.invalidTraitCreationError("J.Identifier is not a variable access");
    }

    static <T> boolean checkType(Cursor parent, Class<T> tClass, Predicate<T> predicate) {
        Object tree = parent.getValue();
        if (tClass.isInstance(tree)) {
            return predicate.test(tClass.cast(tree));
        }
        return false;
    }

    public VarAccessBase(Cursor cursor, J.Identifier identifier) {
        this.cursor = cursor;
        this.identifier = identifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Variable getVariable() {
        Object value = this.variable.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.variable;
            synchronized (atomicReference) {
                value = this.variable.get();
                if (value == null) {
                    Variable actualValue = VarAccessBase.computeVariable(this, this.cursor, this.identifier);
                    value = actualValue == null ? this.variable : actualValue;
                    this.variable.set(value);
                }
            }
        }
        return (Variable)(value == this.variable ? null : value);
    }
}

