/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.controlflow;

import lombok.Generated;
import org.openrewrite.ExecutionContext;
import org.openrewrite.Option;
import org.openrewrite.Recipe;
import org.openrewrite.TreeVisitor;
import org.openrewrite.analysis.controlflow.ControlFlowDotFileGenerator;
import org.openrewrite.analysis.controlflow.ControlFlowVisualizationVisitor;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;

public final class ControlFlowVisualization
extends Recipe {
    @Option(displayName="Include dotfile", description="Also output with a Dotfile which can be then later visualized by Graphviz.")
    private final boolean includeDotfile;
    private final boolean darkMode;
    private final String displayName = "Control flow visualization";
    private final String description = "Visualize the control flow of a Java program.";

    public TreeVisitor<?, ExecutionContext> getVisitor() {
        return new ControlFlowVisualizationVisitor(this.includeDotfile ? ControlFlowDotFileGenerator.create() : null, this.darkMode);
    }

    @Generated
    public ControlFlowVisualization(boolean includeDotfile, boolean darkMode) {
        this.includeDotfile = includeDotfile;
        this.darkMode = darkMode;
    }

    @Generated
    public boolean isIncludeDotfile() {
        return this.includeDotfile;
    }

    @Generated
    public boolean isDarkMode() {
        return this.darkMode;
    }

    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @NonNull
    @Generated
    public String toString() {
        return "ControlFlowVisualization(includeDotfile=" + this.isIncludeDotfile() + ", darkMode=" + this.isDarkMode() + ", displayName=" + this.getDisplayName() + ", description=" + this.getDescription() + ")";
    }

    @Generated
    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ControlFlowVisualization)) {
            return false;
        }
        ControlFlowVisualization other = (ControlFlowVisualization)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (this.isIncludeDotfile() != other.isIncludeDotfile()) {
            return false;
        }
        if (this.isDarkMode() != other.isDarkMode()) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    @Generated
    protected boolean canEqual(@Nullable Object other) {
        return other instanceof ControlFlowVisualization;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isIncludeDotfile() ? 79 : 97);
        result = result * 59 + (this.isDarkMode() ? 79 : 97);
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }
}

