/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.analysis.dataflow;

import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openrewrite.Cursor;
import org.openrewrite.Incubating;
import org.openrewrite.analysis.InvocationMatcher;
import org.openrewrite.analysis.dataflow.DataFlowNode;
import org.openrewrite.analysis.dataflow.internal.csv.CsvLoader;
import org.openrewrite.analysis.dataflow.internal.csv.GenericExternalModel;
import org.openrewrite.analysis.dataflow.internal.csv.Mergeable;
import org.openrewrite.analysis.trait.expr.Call;
import org.openrewrite.internal.lang.NonNull;
import org.openrewrite.internal.lang.Nullable;
import org.openrewrite.java.internal.TypesInUse;
import org.openrewrite.java.tree.J;
import org.openrewrite.java.tree.JavaType;

@Incubating(since="7.25.0")
public final class ExternalSinkModels {
    private static final String CURSOR_MESSAGE_KEY = "OPTIMIZED_SINK_MODELS";
    private static final ExternalSinkModels instance = new ExternalSinkModels();
    private WeakReference<FullyQualifiedNameToSinkModels> fullyQualifiedNameToSinkModel;

    @Deprecated
    public static ExternalSinkModels getInstance() {
        return instance;
    }

    public static ExternalSinkModels instance() {
        return instance;
    }

    FullyQualifiedNameToSinkModels getFullyQualifiedNameToSinkModel() {
        FullyQualifiedNameToSinkModels f;
        if (this.fullyQualifiedNameToSinkModel == null) {
            f = Loader.load();
            this.fullyQualifiedNameToSinkModel = new WeakReference<FullyQualifiedNameToSinkModels>(f);
        } else {
            f = (FullyQualifiedNameToSinkModels)this.fullyQualifiedNameToSinkModel.get();
            if (f == null) {
                f = Loader.load();
                this.fullyQualifiedNameToSinkModel = new WeakReference<FullyQualifiedNameToSinkModels>(f);
            }
        }
        return f;
    }

    private OptimizedSinkModels getOptimizedSinkModelsForTypesInUse(TypesInUse typesInUse) {
        return Optimizer.optimize(this.getFullyQualifiedNameToSinkModel().forTypesInUse(typesInUse));
    }

    private OptimizedSinkModels getOrComputeOptimizedSinkModels(Cursor cursor) {
        Cursor cuCursor = cursor.dropParentUntil(J.CompilationUnit.class::isInstance);
        return (OptimizedSinkModels)cuCursor.computeMessageIfAbsent(CURSOR_MESSAGE_KEY, __ -> this.getOptimizedSinkModelsForTypesInUse(((J.CompilationUnit)cuCursor.getValue()).getTypesInUse()));
    }

    public boolean isSinkNode(DataFlowNode sinkNode, String kind) {
        for (SinkNodePredicate predicate : this.getOrComputeOptimizedSinkModels(sinkNode.getCursor()).forKind(kind)) {
            if (!predicate.isSinkNode(sinkNode)) continue;
            return true;
        }
        return false;
    }

    private ExternalSinkModels() {
    }

    static class Loader {
        Loader() {
        }

        static FullyQualifiedNameToSinkModels load() {
            return CsvLoader.loadFromFile("sinks.csv", FullyQualifiedNameToSinkModels.empty(), Loader::createFullyQualifiedNameToFlowModels, tokens -> new SinkModel(tokens[0], tokens[1], Boolean.parseBoolean(tokens[2]), tokens[3], tokens[4], tokens[5], tokens[6], tokens[7], tokens[8]));
        }

        private static FullyQualifiedNameToSinkModels createFullyQualifiedNameToFlowModels(Iterable<SinkModel> sinkModels) {
            HashMap<String, List<SinkModel>> fqnToSinkModels = new HashMap<String, List<SinkModel>>();
            for (SinkModel sinkModel : sinkModels) {
                fqnToSinkModels.computeIfAbsent(sinkModel.getFullyQualifiedName(), k -> new ArrayList()).add(sinkModel);
            }
            return new FullyQualifiedNameToSinkModels(fqnToSinkModels);
        }
    }

    static class FullyQualifiedNameToSinkModels
    implements Mergeable<FullyQualifiedNameToSinkModels> {
        private final Map<String, List<SinkModel>> fqnToSinkModels;

        boolean isEmpty() {
            return this.fqnToSinkModels.isEmpty();
        }

        @Override
        public FullyQualifiedNameToSinkModels merge(FullyQualifiedNameToSinkModels other) {
            if (other.isEmpty()) {
                return this;
            }
            if (this.isEmpty()) {
                return other;
            }
            HashMap<String, List<SinkModel>> merged = new HashMap<String, List<SinkModel>>(this.fqnToSinkModels);
            other.fqnToSinkModels.forEach((k, v) -> merged.computeIfAbsent((String)k, kk -> new ArrayList(v.size())).addAll(v));
            return new FullyQualifiedNameToSinkModels(merged);
        }

        SinkModels forTypesInUse(TypesInUse typesInUse) {
            HashMap<String, Set<SinkModel>> sinkModels = new HashMap<String, Set<SinkModel>>();
            typesInUse.getUsedMethods().stream().map(JavaType.Method::getDeclaringType).filter(o -> o != null && !(o instanceof JavaType.Unknown)).map(JavaType.FullyQualified::getFullyQualifiedName).distinct().flatMap(fqn -> this.fqnToSinkModels.getOrDefault(fqn, Collections.emptyList()).stream()).forEach(sinkModel -> sinkModels.computeIfAbsent(sinkModel.kind, k -> new HashSet(1)).add(sinkModel));
            return new SinkModels(sinkModels);
        }

        SinkModels forAll() {
            return new SinkModels(this.fqnToSinkModels.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashSet((Collection)e.getValue()))));
        }

        static FullyQualifiedNameToSinkModels empty() {
            return new FullyQualifiedNameToSinkModels(new HashMap<String, List<SinkModel>>(0));
        }

        public FullyQualifiedNameToSinkModels(Map<String, List<SinkModel>> fqnToSinkModels) {
            this.fqnToSinkModels = fqnToSinkModels;
        }
    }

    static class SinkModels {
        Map<String, Set<SinkModel>> sinkModels;

        Set<SinkModel> getSinkModels() {
            return this.sinkModels.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
        }

        public SinkModels(Map<String, Set<SinkModel>> sinkModels) {
            this.sinkModels = sinkModels;
        }
    }

    static class Optimizer {
        Optimizer() {
        }

        private SinkNodePredicate sinkNodePredicateForArgumentIndex(int argumentIndex, Collection<? extends InvocationMatcher> methodMatchers) {
            InvocationMatcher invocationMatcher = InvocationMatcher.from(methodMatchers);
            return argumentIndex == -1 ? sinkNode -> invocationMatcher.advanced().isSelect(sinkNode.getCursor()) : sinkNode -> invocationMatcher.advanced().isParameter(sinkNode.getCursor(), argumentIndex);
        }

        private SinkNodePredicate sinkNodePredicateForReturnValue(Collection<? extends InvocationMatcher> methodMatchers) {
            InvocationMatcher invocationMatcher = InvocationMatcher.from(methodMatchers);
            return sinkNode -> (Boolean)sinkNode.asExprParent(Call.class).map(call -> call.matches(invocationMatcher)).orSome((Object)false);
        }

        private Set<PredicateToSinkModels> optimize(Collection<SinkModel> models) {
            HashMap sinkForArgument = new HashMap();
            HashSet<SinkModel> sinkForReturnValue = new HashSet<SinkModel>(0);
            for (SinkModel model : models) {
                model.getArgumentRange().ifPresent(argumentRange -> {
                    for (int i = argumentRange.getStart(); i <= argumentRange.getEnd(); ++i) {
                        sinkForArgument.computeIfAbsent(i, __ -> new HashSet()).add(model);
                    }
                });
                if (!"ReturnValue".equals(model.input)) continue;
                sinkForReturnValue.add(model);
            }
            Stream<PredicateToSinkModels> predicateToSinkModelsStream = sinkForArgument.entrySet().stream().map(entry -> new PredicateToSinkModels(this.sinkNodePredicateForArgumentIndex((Integer)entry.getKey(), (Collection)entry.getValue()), (Set)entry.getValue()));
            Stream returnValuePredicateToSinkModelsStream = sinkForReturnValue.isEmpty() ? Stream.empty() : Stream.of(new PredicateToSinkModels(this.sinkNodePredicateForReturnValue(sinkForReturnValue), sinkForReturnValue));
            return Stream.concat(predicateToSinkModelsStream, returnValuePredicateToSinkModelsStream).collect(Collectors.toSet());
        }

        static OptimizedSinkModels optimize(SinkModels sinkModels) {
            Optimizer optimizer = new Optimizer();
            Map<String, Set<PredicateToSinkModels>> sinkKindToPredicates = sinkModels.sinkModels.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<String, Set<PredicateToSinkModels>>((String)e.getKey(), optimizer.optimize((Collection)e.getValue()))).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
            return new OptimizedSinkModels(sinkKindToPredicates);
        }
    }

    static class OptimizedSinkModels {
        private final Map<String, Set<PredicateToSinkModels>> sinkKindToPredicates;

        private Set<? extends SinkNodePredicate> forKind(String kind) {
            return this.sinkKindToPredicates.getOrDefault(kind, Collections.emptySet());
        }

        Set<SinkModel> getSinkModels() {
            return this.sinkKindToPredicates.values().stream().flatMap(Collection::stream).map(PredicateToSinkModels::getSinkModels).flatMap(Collection::stream).collect(Collectors.toSet());
        }

        public OptimizedSinkModels(Map<String, Set<PredicateToSinkModels>> sinkKindToPredicates) {
            this.sinkKindToPredicates = sinkKindToPredicates;
        }
    }

    private static interface SinkNodePredicate {
        public boolean isSinkNode(DataFlowNode var1);
    }

    static class SinkModel
    implements GenericExternalModel {
        String namespace;
        String type;
        boolean subtypes;
        String name;
        String signature;
        String ext;
        String input;
        String kind;
        String provenance;

        @Override
        public String getArguments() {
            return this.input;
        }

        public SinkModel(String namespace, String type, boolean subtypes, String name, String signature, String ext, String input, String kind, String provenance) {
            this.namespace = namespace;
            this.type = type;
            this.subtypes = subtypes;
            this.name = name;
            this.signature = signature;
            this.ext = ext;
            this.input = input;
            this.kind = kind;
            this.provenance = provenance;
        }

        @NonNull
        public String toString() {
            return "ExternalSinkModels.SinkModel(namespace=" + this.getNamespace() + ", type=" + this.getType() + ", subtypes=" + this.isSubtypes() + ", name=" + this.getName() + ", signature=" + this.getSignature() + ", ext=" + this.ext + ", input=" + this.input + ", kind=" + this.kind + ", provenance=" + this.provenance + ")";
        }

        @Override
        public String getNamespace() {
            return this.namespace;
        }

        @Override
        public String getType() {
            return this.type;
        }

        @Override
        public boolean isSubtypes() {
            return this.subtypes;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getSignature() {
            return this.signature;
        }
    }

    static final class PredicateToSinkModels
    implements SinkNodePredicate {
        private final SinkNodePredicate predicate;
        private final Set<SinkModel> sinkModels;

        @Override
        public boolean isSinkNode(DataFlowNode sinkNode) {
            return this.predicate.isSinkNode(sinkNode);
        }

        public PredicateToSinkModels(SinkNodePredicate predicate, Set<SinkModel> sinkModels) {
            this.predicate = predicate;
            this.sinkModels = sinkModels;
        }

        public SinkNodePredicate getPredicate() {
            return this.predicate;
        }

        public Set<SinkModel> getSinkModels() {
            return this.sinkModels;
        }

        public boolean equals(@Nullable Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PredicateToSinkModels)) {
                return false;
            }
            PredicateToSinkModels other = (PredicateToSinkModels)o;
            SinkNodePredicate this$predicate = this.getPredicate();
            SinkNodePredicate other$predicate = other.getPredicate();
            if (this$predicate == null ? other$predicate != null : !this$predicate.equals(other$predicate)) {
                return false;
            }
            Set<SinkModel> this$sinkModels = this.getSinkModels();
            Set<SinkModel> other$sinkModels = other.getSinkModels();
            return !(this$sinkModels == null ? other$sinkModels != null : !((Object)this$sinkModels).equals(other$sinkModels));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SinkNodePredicate $predicate = this.getPredicate();
            result = result * 59 + ($predicate == null ? 43 : $predicate.hashCode());
            Set<SinkModel> $sinkModels = this.getSinkModels();
            result = result * 59 + ($sinkModels == null ? 43 : ((Object)$sinkModels).hashCode());
            return result;
        }

        @NonNull
        public String toString() {
            return "ExternalSinkModels.PredicateToSinkModels(predicate=" + this.getPredicate() + ", sinkModels=" + this.getSinkModels() + ")";
        }
    }
}

