/*
 * Decompiled with CFR 0.152.
 */
package org.openrewrite.gradle.toolingapi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ModelBuilder;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.internal.consumer.DefaultGradleConnector;
import org.jspecify.annotations.Nullable;
import org.openrewrite.gradle.toolingapi.OpenRewriteModel;
import org.openrewrite.gradle.toolingapi.OpenRewriteModelProxy;

public class OpenRewriteModelBuilder {
    public static OpenRewriteModel forProjectDirectory(File projectDir, @Nullable File buildFile) throws IOException {
        return OpenRewriteModelBuilder.forProjectDirectory(projectDir, buildFile, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OpenRewriteModel forProjectDirectory(File projectDir, @Nullable File buildFile, @Nullable String initScript) throws IOException {
        DefaultGradleConnector connector = (DefaultGradleConnector)GradleConnector.newConnector();
        if (System.getProperty("org.openrewrite.test.gradleVersion") != null) {
            connector.useGradleVersion(System.getProperty("org.openrewrite.test.gradleVersion"));
        } else if (Files.exists(projectDir.toPath().resolve("gradle/wrapper/gradle-wrapper.properties"), new LinkOption[0])) {
            connector.useBuildDistribution();
        } else {
            connector.useGradleVersion("8.12");
        }
        connector.forProjectDirectory(projectDir);
        ArrayList<String> arguments = new ArrayList<String>();
        if (buildFile != null && buildFile.exists()) {
            arguments.add("-b");
            arguments.add(buildFile.getAbsolutePath());
        }
        arguments.add("--init-script");
        Path init = projectDir.toPath().resolve("openrewrite-tooling.gradle").toAbsolutePath();
        arguments.add(init.toString());
        try (ProjectConnection connection = connector.connect();){
            OpenRewriteModel openRewriteModel;
            ModelBuilder customModelBuilder = connection.model(OpenRewriteModelProxy.class);
            try {
                if (initScript == null) {
                    if (System.getProperty("org.openrewrite.gradle.local.use-embedded-classpath") != null) {
                        String generatedInitScript = OpenRewriteModelBuilder.generateInitScriptFromManifest();
                        Files.write(init, generatedInitScript.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
                    } else {
                        try (InputStream is = OpenRewriteModel.class.getResourceAsStream("/init.gradle");){
                            if (is == null) {
                                throw new IllegalStateException("Expected to find init.gradle on the classpath");
                            }
                            Files.copy(is, init, new CopyOption[0]);
                        }
                    }
                } else {
                    Files.write(init, initScript.getBytes(), new OpenOption[0]);
                }
                customModelBuilder.withArguments(arguments);
                openRewriteModel = OpenRewriteModel.from((OpenRewriteModelProxy)customModelBuilder.get());
            }
            catch (Throwable throwable) {
                try {
                    if (Files.exists(init, new LinkOption[0])) {
                        Files.delete(init);
                    }
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                throw throwable;
            }
            try {
                if (Files.exists(init, new LinkOption[0])) {
                    Files.delete(init);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return openRewriteModel;
        }
    }

    private static String generateInitScriptFromManifest() throws IOException {
        String manifestPath = System.getProperty("org.openrewrite.gradle.local.use-embedded-classpath");
        if (manifestPath == null || manifestPath.isEmpty()) {
            throw new IllegalStateException("System property org.openrewrite.gradle.local.use-embedded-classpath must be set to the path of test-manifest.txt");
        }
        Path manifestFile = Paths.get(manifestPath, new String[0]);
        if (!Files.exists(manifestFile, new LinkOption[0])) {
            throw new IllegalStateException("Manifest file not found at: " + manifestPath);
        }
        StringBuilder initScript = new StringBuilder();
        initScript.append("initscript {\n");
        initScript.append("    dependencies {\n");
        List<String> lines = Files.readAllLines(manifestFile, StandardCharsets.UTF_8);
        for (String line : lines) {
            if ((line = line.trim()).isEmpty()) continue;
            String escapedPath = line.replace("\\", "\\\\");
            initScript.append("        classpath files('").append(escapedPath).append("')\n");
        }
        initScript.append("    }\n");
        initScript.append("}\n\n");
        initScript.append("allprojects {\n");
        initScript.append("    apply plugin: org.openrewrite.gradle.toolingapi.ToolingApiOpenRewriteModelPlugin\n");
        initScript.append("}\n");
        return initScript.toString();
    }
}

