/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.util.HashSet;
import java.util.Set;
import org.openl.dependency.CompiledDependency;
import org.openl.rules.lang.xls.binding.XlsMetaInfo;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.validation.ValidationUtils;
import org.openl.rules.validation.properties.dimentional.DispatcherTablesBuilder;
import org.openl.types.IOpenClass;
import org.openl.validation.IOpenLValidator;
import org.openl.validation.ValidationResult;

public abstract class TablesValidator
implements IOpenLValidator {
    private void findAllTableSyntaxNodes(Set<TableSyntaxNode> tableSyntaxNodes, IOpenClass openClass) {
        if (openClass instanceof XlsModuleOpenClass) {
            for (CompiledDependency compiledDependency : ((XlsModuleOpenClass)openClass).getDependencies()) {
                IOpenClass dependencyOpenClass = compiledDependency.getCompiledOpenClass().getOpenClassWithErrors();
                this.findAllTableSyntaxNodes(tableSyntaxNodes, dependencyOpenClass);
            }
            XlsMetaInfo xlsMetaInfo = ((XlsModuleOpenClass)openClass).getXlsMetaInfo();
            if (xlsMetaInfo != null) {
                TableSyntaxNode[] xlsTableSyntaxNodes;
                for (TableSyntaxNode tableSyntaxNode : xlsTableSyntaxNodes = xlsMetaInfo.getXlsModuleNode().getXlsTableSyntaxNodes()) {
                    if (DispatcherTablesBuilder.isDispatcherTable(tableSyntaxNode)) continue;
                    tableSyntaxNodes.add(tableSyntaxNode);
                }
            }
        }
    }

    public ValidationResult validate(IOpenClass openClass) {
        if (openClass instanceof XlsModuleOpenClass) {
            HashSet<TableSyntaxNode> tableSyntaxNodes = new HashSet<TableSyntaxNode>();
            this.findAllTableSyntaxNodes(tableSyntaxNodes, openClass);
            return this.validateTables(tableSyntaxNodes.toArray(TableSyntaxNode.EMPTY_ARRAY), openClass);
        }
        return ValidationUtils.validationSuccess();
    }

    public abstract ValidationResult validateTables(TableSyntaxNode[] var1, IOpenClass var2);
}

