/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.validation;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.openl.message.OpenLMessage;
import org.openl.message.OpenLMessagesUtils;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.PropertiesHelper;
import org.openl.rules.types.OpenMethodDispatcher;
import org.openl.rules.validation.ValidationUtils;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IMemberMetaInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethod;
import org.openl.validation.IOpenLValidator;
import org.openl.validation.ValidationResult;

public class DimensionalPropertyValidator
implements IOpenLValidator {
    public ValidationResult validate(IOpenClass openClass) {
        LinkedHashSet<OpenLMessage> messages = new LinkedHashSet<OpenLMessage>();
        String[] vResult = new String[3];
        for (IOpenMethod method : openClass.getMethods()) {
            if (!(method instanceof OpenMethodDispatcher)) continue;
            OpenMethodDispatcher openMethodDispatcher = (OpenMethodDispatcher)method;
            IOpenMethod[] methods = openMethodDispatcher.getCandidates().toArray(IOpenMethod.EMPTY_ARRAY);
            for (int i = 0; i < methods.length - 1; ++i) {
                ITableProperties propsA = PropertiesHelper.getTableProperties(methods[i]);
                Map<String, Object> propertiesA = propsA.getAllDimensionalProperties();
                for (int j = i + 1; j < methods.length; ++j) {
                    Object p;
                    Object prop;
                    OverlapState overlapState = OverlapState.UNKNOWN;
                    for (int q = 0; q < 3; ++q) {
                        vResult[q] = null;
                    }
                    ITableProperties propsB = PropertiesHelper.getTableProperties(methods[j]);
                    Map<String, Object> propertiesB = propsB.getAllDimensionalProperties();
                    HashSet<String> usedKeys = new HashSet<String>();
                    for (String propKey : propertiesA.keySet()) {
                        if (OverlapState.NOT_OVERLAP == overlapState) break;
                        usedKeys.add(propKey);
                        prop = propertiesA.get(propKey);
                        p = propertiesB.get(propKey);
                        overlapState = this.loopInternal(overlapState, vResult, propKey, prop, p);
                    }
                    for (String propKey : propertiesB.keySet()) {
                        if (OverlapState.NOT_OVERLAP == overlapState) break;
                        if (usedKeys.contains(propKey)) continue;
                        prop = propertiesA.get(propKey);
                        p = propertiesB.get(propKey);
                        overlapState = this.loopInternal(overlapState, vResult, propKey, prop, p);
                    }
                    if (overlapState != OverlapState.OVERLAP) continue;
                    StringBuilder sb = new StringBuilder();
                    if (vResult[2] != null) {
                        String pKey = vResult[2];
                        Object valueA = propertiesA.get(pKey);
                        Object valueB = propertiesB.get(pKey);
                        sb.append("(");
                        this.writeMessageForProperty(sb, pKey, valueA);
                        sb.append(")");
                        sb.append(" and ");
                        sb.append("(");
                        this.writeMessageForProperty(sb, pKey, valueB);
                        sb.append(")");
                    } else {
                        String pKey1 = vResult[0];
                        Object value1A = propertiesA.get(pKey1);
                        Object value1B = propertiesB.get(pKey1);
                        String pKey2 = vResult[1];
                        Object value2A = propertiesA.get(pKey2);
                        Object value2B = propertiesB.get(pKey2);
                        sb.append("(");
                        this.writeMessageForProperty(sb, pKey1, value1A);
                        sb.append(", ");
                        this.writeMessageForProperty(sb, pKey2, value2A);
                        sb.append(")");
                        sb.append(" and ");
                        sb.append("(");
                        this.writeMessageForProperty(sb, pKey1, value1B);
                        sb.append(", ");
                        this.writeMessageForProperty(sb, pKey2, value2B);
                        sb.append(")");
                    }
                    this.addValidationWarn(messages, sb.toString(), methods[i]);
                    this.addValidationWarn(messages, sb.toString(), methods[j]);
                }
            }
        }
        return ValidationUtils.withMessages(messages);
    }

    OverlapState loopInternal(OverlapState overlapState, String[] vResult, String propKey, Object prop, Object p) {
        if (prop == null && p == null) {
            return overlapState;
        }
        if (!OverlapState.OVERLAP.equals((Object)overlapState)) {
            if (prop == null) {
                overlapState = OverlapState.INCLUDE_TO_B == overlapState ? OverlapState.OVERLAP : OverlapState.INCLUDE_TO_A;
                vResult[0] = propKey;
                return overlapState;
            }
            if (p == null) {
                overlapState = OverlapState.INCLUDE_TO_A == overlapState ? OverlapState.OVERLAP : OverlapState.INCLUDE_TO_B;
                vResult[1] = propKey;
                return overlapState;
            }
        } else if (prop == null || p == null) {
            return overlapState;
        }
        if (prop.getClass().isArray()) {
            boolean f3;
            int length1 = Array.getLength(prop);
            int length2 = Array.getLength(p);
            boolean f1 = false;
            boolean f2 = false;
            Set<Object> propSet = this.arrayToSet(prop, length1);
            Set<Object> pSet = this.arrayToSet(p, length2);
            propSet.retainAll(pSet);
            int d = propSet.size();
            if (OverlapState.OVERLAP != overlapState) {
                if (length1 < length2) {
                    f2 = d == length1;
                } else {
                    boolean bl = f1 = d == length2;
                    if (length1 == length2) {
                        f2 = f1;
                    }
                }
            }
            boolean bl = f3 = d == 0;
            if (f3) {
                overlapState = OverlapState.NOT_OVERLAP;
                return overlapState;
            }
            if (OverlapState.OVERLAP != overlapState) {
                if (f1 && f2) {
                    return overlapState;
                }
                if (f1) {
                    overlapState = OverlapState.INCLUDE_TO_B == overlapState ? OverlapState.OVERLAP : OverlapState.INCLUDE_TO_A;
                    vResult[0] = propKey;
                    return overlapState;
                }
                if (f2) {
                    overlapState = OverlapState.INCLUDE_TO_A == overlapState ? OverlapState.OVERLAP : OverlapState.INCLUDE_TO_B;
                    vResult[1] = propKey;
                    return overlapState;
                }
                overlapState = OverlapState.OVERLAP;
                vResult[2] = propKey;
            }
        } else {
            if (!prop.equals(p)) {
                overlapState = OverlapState.NOT_OVERLAP;
            }
            return overlapState;
        }
        return overlapState;
    }

    private Set<Object> arrayToSet(Object array, int length) {
        HashSet<Object> set = new HashSet<Object>();
        for (int k = 0; k < length; ++k) {
            set.add(Array.get(array, k));
        }
        return set;
    }

    private void writeMessageForProperty(StringBuilder sb, String pKey, Object value) {
        sb.append(pKey);
        sb.append("={");
        if (value != null) {
            if (value.getClass().isArray()) {
                int length = Array.getLength(value);
                for (int k = 0; k < length; ++k) {
                    if (k != 0) {
                        sb.append(", ");
                    }
                    this.writeObject(sb, Array.get(value, k));
                }
            } else {
                this.writeObject(sb, value);
            }
        }
        sb.append("}");
    }

    private void writeObject(StringBuilder sb, Object value) {
        if (value.getClass().isEnum()) {
            sb.append(((Enum)value).name());
        } else {
            sb.append(value.toString());
        }
    }

    private void addValidationWarn(Collection<OpenLMessage> messages, String message, IOpenMethod method) {
        IMemberMetaInfo memberMetaInfo = (IMemberMetaInfo)method;
        if (memberMetaInfo.getSyntaxNode() instanceof TableSyntaxNode) {
            messages.add(OpenLMessagesUtils.newWarnMessage((String)("Ambiguous definition of properties values. Details: " + message), (ISyntaxNode)memberMetaInfo.getSyntaxNode()));
        }
    }

    static enum OverlapState {
        OVERLAP,
        INCLUDE_TO_A,
        INCLUDE_TO_B,
        NOT_OVERLAP,
        UNKNOWN;

    }
}

