/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.runtime;

import org.openl.IOpenRunner;
import org.openl.rules.tbasic.runtime.TBasicVM;
import org.openl.runtime.IRuntimeContext;
import org.openl.types.impl.DelegatedDynamicObject;
import org.openl.vm.IRuntimeEnv;

public class TBasicContextHolderEnv
implements IRuntimeEnv {
    private final IRuntimeEnv env;
    private final TBasicVM tbasicVm;
    private final DelegatedDynamicObject tbasicTarget;
    private final Object[] tbasicParams;

    public TBasicContextHolderEnv(IRuntimeEnv env, DelegatedDynamicObject tbasicTarget, Object[] params, TBasicVM tbasicVM) {
        this.env = env;
        this.tbasicVm = tbasicVM;
        this.tbasicParams = params;
        this.tbasicTarget = tbasicTarget;
    }

    public void assignValueToVariable(String variableName, Object value) {
        this.tbasicTarget.setFieldValue(variableName, value);
    }

    public IRuntimeEnv getEnv() {
        return this.env;
    }

    public Object[] getLocalFrame() {
        return this.env.getLocalFrame();
    }

    public IOpenRunner getRunner() {
        return this.env.getRunner();
    }

    public Object[] getTbasicParams() {
        return this.tbasicParams;
    }

    public DelegatedDynamicObject getTbasicTarget() {
        return this.tbasicTarget;
    }

    public TBasicVM getTbasicVm() {
        return this.tbasicVm;
    }

    public Object getThis() {
        return this.env.getThis();
    }

    public Object[] popLocalFrame() {
        return this.env.popLocalFrame();
    }

    public Object popThis() {
        return this.env.popThis();
    }

    public void pushLocalFrame(Object[] frame) {
        this.env.pushLocalFrame(frame);
    }

    public void pushThis(Object thisObject) {
        this.env.pushThis(thisObject);
    }

    public IRuntimeContext getContext() {
        return this.env.getContext();
    }

    public void setContext(IRuntimeContext context) {
        this.env.setContext(context);
    }

    public boolean isContextManagingSupported() {
        return this.env.isContextManagingSupported();
    }

    public IRuntimeContext popContext() {
        return this.env.popContext();
    }

    public void pushContext(IRuntimeContext context) {
        this.env.pushContext(context);
    }
}

