/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.tbasic.compile;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.BindHelper;
import org.openl.rules.tbasic.AlgorithmTreeNode;
import org.openl.rules.tbasic.runtime.operations.RuntimeOperation;
import org.openl.source.IOpenSourceCodeModule;

public class CompileContext {
    private final List<RuntimeOperation> operations = new ArrayList<RuntimeOperation>();
    private final Map<String, RuntimeOperation> localLabelsRegister = new HashMap<String, RuntimeOperation>();
    private final Map<String, AlgorithmTreeNode> existingLables = new HashMap<String, AlgorithmTreeNode>();

    public Map<String, AlgorithmTreeNode> getExistingLables() {
        return this.existingLables;
    }

    public Map<String, RuntimeOperation> getLocalLabelsRegister() {
        return this.localLabelsRegister;
    }

    public List<RuntimeOperation> getOperations() {
        return this.operations;
    }

    public boolean isLabelRegistered(String labelName) {
        return this.existingLables.containsKey(labelName);
    }

    public void registerGroupOfLabels(Map<String, AlgorithmTreeNode> labelToAdd, IBindingContext bindingContext) {
        for (Map.Entry<String, AlgorithmTreeNode> label : labelToAdd.entrySet()) {
            this.registerNewLabel(label.getKey(), label.getValue(), bindingContext);
        }
    }

    public void registerNewLabel(String labelName, AlgorithmTreeNode sourceNode, IBindingContext bindingContext) {
        if (this.isLabelRegistered(labelName)) {
            IOpenSourceCodeModule errorSource = sourceNode.getAlgorithmRow().getOperation().asSourceCodeModule();
            BindHelper.processError((String)("Such label has been already declared : '" + labelName + "'."), (IOpenSourceCodeModule)errorSource, (IBindingContext)bindingContext);
        } else {
            this.existingLables.put(labelName, sourceNode);
        }
    }

    public void setLabel(String labelName, RuntimeOperation labeledOperation, IBindingContext bindingContext) {
        if (this.isLabelRegistered(labelName)) {
            this.localLabelsRegister.put(labelName, labeledOperation);
        } else {
            IOpenSourceCodeModule errorSource = labeledOperation.getSourceCode().getSourceModule();
            BindHelper.processError((String)("Such lablel is not declared : '" + labelName + "'."), (IOpenSourceCodeModule)errorSource, (IBindingContext)bindingContext);
        }
    }

    public void addOperations(List<RuntimeOperation> operations) {
        if (operations != null) {
            this.operations.addAll(operations);
        }
    }
}

