/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.xls;

import java.util.Date;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openl.rules.lang.xls.load.CellLoader;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.ICell;
import org.openl.rules.table.ICellComment;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.ui.ICellFont;
import org.openl.rules.table.ui.ICellStyle;
import org.openl.rules.table.xls.XlsCellComment;
import org.openl.rules.table.xls.XlsCellFont;
import org.openl.rules.table.xls.XlsCellStyle;
import org.openl.rules.table.xls.XlsSheetGridModel;
import org.openl.rules.table.xls.XlsUtil;
import org.openl.util.NumberUtils;
import org.openl.util.StringPool;
import org.openl.util.StringUtils;

public class XlsCell
implements ICell {
    private final int column;
    private final int row;
    private final IGridRegion region;
    private final CellLoader cellLoader;
    private int width = 1;
    private int height = 1;
    private final XlsSheetGridModel gridModel;

    public XlsCell(int column, int row, XlsSheetGridModel gridModel) {
        this.column = column;
        this.row = row;
        this.region = gridModel.getRegionContaining(column, row);
        this.cellLoader = gridModel.getSheetSource().getSheetLoader().getCellLoader(column, row);
        if (this.region != null && this.region.getLeft() == column && this.region.getTop() == row) {
            this.width = this.region.getRight() - this.region.getLeft() + 1;
            this.height = this.region.getBottom() - this.region.getTop() + 1;
        }
        this.gridModel = gridModel;
    }

    @Override
    public ICellStyle getStyle() {
        Cell cell = this.getCell();
        if (cell == null) {
            return null;
        }
        CellStyle style = cell.getCellStyle();
        if (style == null) {
            return null;
        }
        Workbook workbook = this.gridModel.getSheetSource().getSheet().getWorkbook();
        return new XlsCellStyle(style, workbook);
    }

    @Override
    public int getAbsoluteColumn() {
        return this.getColumn();
    }

    @Override
    public int getAbsoluteRow() {
        return this.getRow();
    }

    @Override
    public IGridRegion getAbsoluteRegion() {
        IGridRegion absoluteRegion = this.getRegion();
        if (absoluteRegion == null) {
            absoluteRegion = new GridRegion(this.row, this.column, this.row, this.column);
        }
        return absoluteRegion;
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    @Override
    public ICellFont getFont() {
        Cell cell = this.getCell();
        if (cell == null) {
            return null;
        }
        Font font = this.gridModel.getSheetSource().getSheet().getWorkbook().getFontAt(cell.getCellStyle().getFontIndexAsInt());
        return new XlsCellFont(font, this.gridModel.getSheetSource().getSheet().getWorkbook());
    }

    @Override
    public int getRow() {
        return this.row;
    }

    @Override
    public IGridRegion getRegion() {
        return this.region;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public Object getObjectValue() {
        if (this.region == null || this.isCurrentCellATopLeftCellInRegion()) {
            return this.extractCellValue();
        }
        ICell topLeftCell = this.getTopLeftCellFromRegion();
        return topLeftCell.getObjectValue();
    }

    @Override
    public String getStringValue() {
        Object res = this.getObjectValue();
        return res == null ? null : String.valueOf(res);
    }

    public void setStringValue(String value) {
        this.getCell().setCellValue(value);
    }

    @Override
    public ICell getTopLeftCellFromRegion() {
        int row = this.region.getTop();
        int col = this.region.getLeft();
        return this.gridModel.getCell(col, row);
    }

    private boolean isCurrentCellATopLeftCellInRegion() {
        ICell topLeftCell = this.getTopLeftCellFromRegion();
        return topLeftCell.getColumn() == this.column && topLeftCell.getRow() == this.row;
    }

    private Object extractCellValue() {
        Cell cell = this.getCell();
        if (cell != null) {
            CellType type = cell.getCellType();
            if (type == CellType.FORMULA) {
                type = cell.getCachedFormulaResultType();
            }
            switch (type) {
                case BLANK: {
                    return null;
                }
                case BOOLEAN: {
                    return cell.getBooleanCellValue();
                }
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        return cell.getDateCellValue();
                    }
                    double value = cell.getNumericCellValue();
                    return NumberUtils.intOrDouble((double)value);
                }
                case STRING: {
                    String str = StringUtils.trimToNull((String)cell.getStringCellValue());
                    return StringPool.intern((String)str);
                }
            }
            return "unknown type: " + cell.getCellType();
        }
        return null;
    }

    @Override
    public String getFormula() {
        Cell cell = this.getCell();
        if (cell == null && this.region == null) {
            return null;
        }
        if (this.region == null || this.isCurrentCellATopLeftCellInRegion()) {
            return cell.getCellType() == CellType.FORMULA ? cell.getCellFormula() : null;
        }
        ICell topLeftCell = this.getTopLeftCellFromRegion();
        return topLeftCell.getType() == 2 ? topLeftCell.getFormula() : null;
    }

    @Override
    public int getType() {
        Cell cell = this.getCell();
        if (cell == null && this.region == null) {
            return 3;
        }
        if (this.region == null || this.isCurrentCellATopLeftCellInRegion()) {
            return this.getIGridCellType(cell.getCellType());
        }
        ICell topLeftCell = this.getTopLeftCellFromRegion();
        return topLeftCell.getType();
    }

    @Override
    public String getUri() {
        return XlsUtil.xlsCellPresentation(this.column, this.row);
    }

    @Override
    public boolean getNativeBoolean() {
        return true;
    }

    @Override
    public double getNativeNumber() {
        Cell cell = this.getCell();
        if (cell == null) {
            return 0.0;
        }
        return cell.getNumericCellValue();
    }

    @Override
    public int getNativeType() {
        Cell cell = this.getCell();
        if (cell == null) {
            return 3;
        }
        CellType type = cell.getCellType();
        if (type == CellType.FORMULA) {
            return this.getIGridCellType(cell.getCachedFormulaResultType());
        }
        return this.getIGridCellType(type);
    }

    @Override
    public boolean hasNativeType() {
        return true;
    }

    @Override
    public Date getNativeDate() {
        Cell cell = this.getCell();
        if (cell == null) {
            return null;
        }
        if (CellType.STRING.equals((Object)cell.getCellType())) {
            double doubleValue;
            try {
                doubleValue = Double.parseDouble(cell.getStringCellValue());
            }
            catch (NumberFormatException npe) {
                throw new IllegalStateException("Cannot parse the value as a date : " + cell.getNumericCellValue());
            }
            Workbook workbook = cell.getSheet().getWorkbook();
            boolean date1904 = false;
            if (workbook instanceof XSSFWorkbook) {
                date1904 = ((XSSFWorkbook)workbook).isDate1904();
            } else if (workbook instanceof HSSFWorkbook) {
                date1904 = ((HSSFWorkbook)workbook).getInternalWorkbook().isUsing1904DateWindowing();
            }
            return DateUtil.getJavaDate((double)doubleValue, (boolean)date1904);
        }
        try {
            return cell.getDateCellValue();
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException("Cannot parse the value as a date : " + cell.getNumericCellValue());
        }
    }

    @Override
    public ICellComment getComment() {
        Cell cell = this.getCell();
        if (cell != null) {
            Comment comment = cell.getCellComment();
            if (comment != null) {
                return new XlsCellComment(comment);
            }
            if (this.region != null && !this.isCurrentCellATopLeftCellInRegion()) {
                ICell topLeftCell = this.getTopLeftCellFromRegion();
                return topLeftCell.getComment();
            }
        }
        return null;
    }

    private Cell getCell() {
        return this.cellLoader.getCell();
    }

    private int getIGridCellType(CellType cellType) {
        switch (cellType) {
            case NUMERIC: {
                return 0;
            }
            case STRING: {
                return 1;
            }
            case FORMULA: {
                return 2;
            }
            case BLANK: {
                return 3;
            }
            case BOOLEAN: {
                return 4;
            }
            case ERROR: {
                return 5;
            }
        }
        throw new IllegalArgumentException("Unsupported cell type " + cellType);
    }
}

