/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.properties.def;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.openl.rules.convertor.IString2DataConvertor;
import org.openl.rules.convertor.String2DataConvertorFactory;
import org.openl.rules.lang.xls.XlsNodeTypes;
import org.openl.rules.table.properties.ITableProperties;
import org.openl.rules.table.properties.TableProperties;
import org.openl.rules.table.properties.def.DefaultPropertyDefinitions;
import org.openl.rules.table.properties.def.TablePropertyDefinition;
import org.openl.rules.table.properties.inherit.InheritanceLevel;
import org.openl.rules.table.properties.inherit.PropertiesChecker;
import org.openl.util.StringUtils;

public final class TablePropertyDefinitionUtils {
    private static final TablePropertyDefinition[] NO_PROPERTIES;
    private static final List<TablePropertyDefinition> PROPERTIES_TO_BE_SET_BY_DEFAULT;
    private static final Map<String, Object> PROPERTIES_MAP_TO_BE_SET_BY_DEFAULT;
    private static final Map<String, Object> GLOBAL_PROPERTIES_MAP_TO_BE_SET_BY_DEFAULT;
    private static String[] dimensionalTablePropertiesNames;
    private static List<TablePropertyDefinition> dimensionalTableProperties;

    private TablePropertyDefinitionUtils() {
    }

    public static String[] getDimensionalTablePropertiesNames() {
        if (dimensionalTablePropertiesNames == null) {
            ArrayList<String> names = new ArrayList<String>();
            List<TablePropertyDefinition> dimensionalProperties = TablePropertyDefinitionUtils.getDimensionalTableProperties();
            for (TablePropertyDefinition definition : dimensionalProperties) {
                names.add(definition.getName());
            }
            dimensionalTablePropertiesNames = names.toArray(StringUtils.EMPTY_STRING_ARRAY);
        }
        return dimensionalTablePropertiesNames;
    }

    public static List<TablePropertyDefinition> getDimensionalTableProperties() {
        if (dimensionalTableProperties == null) {
            TablePropertyDefinition[] definitions;
            ArrayList<TablePropertyDefinition> dimensionalProperties = new ArrayList<TablePropertyDefinition>();
            for (TablePropertyDefinition definition : definitions = DefaultPropertyDefinitions.getDefaultDefinitions()) {
                if (!definition.isDimensional()) continue;
                dimensionalProperties.add(definition);
            }
            dimensionalTableProperties = Collections.unmodifiableList(dimensionalProperties);
        }
        return dimensionalTableProperties;
    }

    public static Map<String, Object> getGlobalPropertiesToBeSetByDefault() {
        return GLOBAL_PROPERTIES_MAP_TO_BE_SET_BY_DEFAULT;
    }

    public static String getPropertyName(String displayName) {
        for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!propDefinition.getDisplayName().equals(displayName)) continue;
            return propDefinition.getName();
        }
        return null;
    }

    public static String getDefaultValueForProperty(String propertyName) {
        return Arrays.stream(DefaultPropertyDefinitions.getDefaultDefinitions()).filter(e -> Objects.equals(e.getName(), propertyName)).map(TablePropertyDefinition::getDefaultValue).findFirst().orElse(null);
    }

    public static String getPropertyDisplayName(String name) {
        for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!propDefinition.getName().equals(name)) continue;
            return propDefinition.getDisplayName();
        }
        return null;
    }

    public static TablePropertyDefinition getPropertyByName(String name) {
        for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!propDefinition.getName().equals(name)) continue;
            return propDefinition;
        }
        return null;
    }

    public static Class<?> getTypeByPropertyName(String propertyName) {
        TablePropertyDefinition tablePropertyDefinition = TablePropertyDefinitionUtils.getPropertyByName(propertyName);
        if (tablePropertyDefinition != null) {
            return tablePropertyDefinition.getType().getInstanceClass();
        }
        return null;
    }

    public static boolean isPropertyExist(String propertyName) {
        return TablePropertyDefinitionUtils.getPropertyByName(propertyName) != null;
    }

    public static List<TablePropertyDefinition> getPropertiesToBeSetByDefault() {
        return PROPERTIES_TO_BE_SET_BY_DEFAULT;
    }

    public static Map<String, Object> getPropertiesMapToBeSetByDefault() {
        return PROPERTIES_MAP_TO_BE_SET_BY_DEFAULT;
    }

    public static List<TablePropertyDefinition> getSystemProperties() {
        ArrayList<TablePropertyDefinition> result = new ArrayList<TablePropertyDefinition>();
        for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!propDefinition.isSystem()) continue;
            result.add(propDefinition);
        }
        return result;
    }

    public static TablePropertyDefinition[] getDefaultDefinitionsByInheritanceLevel(InheritanceLevel inheritanceLevel) {
        ArrayList<TablePropertyDefinition> resultDefinitions = new ArrayList<TablePropertyDefinition>();
        for (TablePropertyDefinition propertyDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (!ArrayUtils.contains((Object[])propertyDefinition.getInheritanceLevel(), (Object)((Object)inheritanceLevel))) continue;
            resultDefinitions.add(propertyDefinition);
        }
        return resultDefinitions.toArray(NO_PROPERTIES);
    }

    public static TablePropertyDefinition[] getDefaultDefinitionsForTable(String tableType) {
        return TablePropertyDefinitionUtils.getDefaultDefinitionsForTable(tableType, null, false);
    }

    public static TablePropertyDefinition[] getDefaultDefinitionsForTable(String tableType, InheritanceLevel inheritanceLevel, boolean ignoreSystem) {
        ArrayList<TablePropertyDefinition> resultDefinitions = new ArrayList<TablePropertyDefinition>();
        for (TablePropertyDefinition propertyDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            String name = propertyDefinition.getName();
            if (!PropertiesChecker.isPropertySuitableForTableType(name, tableType) || inheritanceLevel != null && !ArrayUtils.contains((Object[])propertyDefinition.getInheritanceLevel(), (Object)((Object)inheritanceLevel)) || ignoreSystem && propertyDefinition.isSystem()) continue;
            resultDefinitions.add(propertyDefinition);
        }
        return resultDefinitions.toArray(NO_PROPERTIES);
    }

    public static Map<String, List<TablePropertyDefinition>> groupProperties(TablePropertyDefinition[] properties) {
        LinkedHashMap<String, List<TablePropertyDefinition>> groups = new LinkedHashMap<String, List<TablePropertyDefinition>>();
        for (TablePropertyDefinition property : properties) {
            String groupName = property.getGroup();
            List group = groups.computeIfAbsent(groupName, e -> new ArrayList());
            group.add(property);
        }
        return groups;
    }

    public static XlsNodeTypes[] getSuitableTableTypes(String propertyName) {
        TablePropertyDefinition propDefinition = TablePropertyDefinitionUtils.getPropertyByName(propertyName);
        if (propDefinition != null) {
            return propDefinition.getTableType();
        }
        return null;
    }

    public static Class<?> getPropertyTypeByPropertyName(String name) {
        TablePropertyDefinition propDefinition = TablePropertyDefinitionUtils.getPropertyByName(name);
        if (propDefinition != null) {
            return propDefinition.getType().getInstanceClass();
        }
        return null;
    }

    public static Map<String, Object> mergeGlobalProperties(Map<String, Object> properties1, Map<String, Object> properties2) {
        if (properties1 == null) {
            return properties2;
        }
        if (properties2 == null) {
            return properties1;
        }
        HashMap<String, Object> mergedGlobalProperties = new HashMap<String, Object>(properties1);
        HashSet<String> keys = new HashSet<String>(properties1.keySet());
        keys.addAll(properties2.keySet());
        for (String key : keys) {
            Object v1 = properties1.get(key);
            Object v2 = properties2.get(key);
            if (v1 == null && properties2.containsKey(key)) {
                mergedGlobalProperties.put(key, v2);
                continue;
            }
            if (v2 == null && properties1.containsKey(key)) {
                mergedGlobalProperties.put(key, v1);
                continue;
            }
            if (!Objects.equals(v1, v2)) {
                String defaultValue = TablePropertyDefinitionUtils.getDefaultValueForProperty(key);
                if (Objects.equals(defaultValue, v1)) {
                    mergedGlobalProperties.put(key, v2);
                } else if (Objects.equals(defaultValue, v2)) {
                    mergedGlobalProperties.put(key, v1);
                } else if (v1 instanceof Comparable && v2 instanceof Comparable && v1.getClass() == v2.getClass()) {
                    mergedGlobalProperties.put(key, ((Comparable)v1).compareTo(v2) < 0 ? v1 : v2);
                }
                throw new IllegalStateException("Failed to merge global properties.");
            }
            mergedGlobalProperties.put(key, v1 != null ? v1 : v2);
        }
        return mergedGlobalProperties;
    }

    public static ITableProperties buildGlobalTableProperties() {
        return TablePropertyDefinitionUtils.buildGlobalTableProperties(null);
    }

    public static ITableProperties buildGlobalTableProperties(Map<String, Object> globalProperties) {
        TableProperties globalTableProperties = new TableProperties();
        if (globalProperties != null) {
            globalTableProperties.setGlobalProperties(globalProperties);
        }
        globalTableProperties.setDefaultProperties(TablePropertyDefinitionUtils.getGlobalPropertiesToBeSetByDefault());
        globalTableProperties.setCurrentTableType(XlsNodeTypes.XLS_PROPERTIES.toString());
        return globalTableProperties;
    }

    static {
        TablePropertyDefinition[] definitions;
        NO_PROPERTIES = new TablePropertyDefinition[0];
        ArrayList<TablePropertyDefinition> propertiesToBeSetByDefault = new ArrayList<TablePropertyDefinition>();
        for (TablePropertyDefinition propDefinition : DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (propDefinition.getDefaultValue() == null) continue;
            propertiesToBeSetByDefault.add(propDefinition);
        }
        PROPERTIES_TO_BE_SET_BY_DEFAULT = Collections.unmodifiableList(propertiesToBeSetByDefault);
        HashMap propertiesMapToBeSetByDefault = new HashMap();
        for (TablePropertyDefinition propertyWithDefaultValue : propertiesToBeSetByDefault) {
            TablePropertyDefinition[] defaultPropertyName = propertyWithDefaultValue.getName();
            TablePropertyDefinition propertyDefinition = TablePropertyDefinitionUtils.getPropertyByName((String)defaultPropertyName);
            Class defaultPropertyValueType = propertyDefinition.getType().getInstanceClass();
            IString2DataConvertor converter = String2DataConvertorFactory.getConvertor(defaultPropertyValueType);
            Object defaultValue = converter.parse(propertyWithDefaultValue.getDefaultValue(), propertyWithDefaultValue.getFormat());
            propertiesMapToBeSetByDefault.put(defaultPropertyName, defaultValue);
        }
        PROPERTIES_MAP_TO_BE_SET_BY_DEFAULT = Collections.unmodifiableMap(propertiesMapToBeSetByDefault);
        ArrayList<TablePropertyDefinition> globalDefaultProperties = new ArrayList<TablePropertyDefinition>();
        for (TablePropertyDefinition definition : definitions = DefaultPropertyDefinitions.getDefaultDefinitions()) {
            if (definition.getInheritanceLevel() == null || !Arrays.asList(definition.getInheritanceLevel()).contains((Object)InheritanceLevel.GLOBAL)) continue;
            globalDefaultProperties.add(definition);
        }
        HashMap<String, Object> defaultGlobalProperties = new HashMap<String, Object>();
        for (TablePropertyDefinition tablePropertyDefinition : globalDefaultProperties) {
            Object v = TablePropertyDefinitionUtils.getPropertiesMapToBeSetByDefault().get(tablePropertyDefinition.getName());
            if (v == null) continue;
            defaultGlobalProperties.put(tablePropertyDefinition.getName(), v);
        }
        GLOBAL_PROPERTIES_MAP_TO_BE_SET_BY_DEFAULT = Collections.unmodifiableMap(defaultGlobalProperties);
        dimensionalTablePropertiesNames = null;
        dimensionalTableProperties = null;
    }
}

