/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table.actions;

import java.util.ArrayList;
import java.util.List;
import org.openl.rules.table.GridRegion;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;
import org.openl.rules.table.IWritableGrid;
import org.openl.rules.table.actions.IUndoableGridTableAction;

public class UnmergeByColumnsAction
implements IUndoableGridTableAction {
    private final IGridRegion region;
    private List<IGridRegion> createdRegions;
    private List<IGridRegion> removedRegions;

    public UnmergeByColumnsAction(IGridRegion region) {
        this.region = region;
    }

    @Override
    public void doAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        this.createdRegions = new ArrayList<IGridRegion>();
        this.removedRegions = new ArrayList<IGridRegion>();
        for (int row = this.region.getTop(); row <= this.region.getBottom(); ++row) {
            for (int column = this.region.getLeft(); column < this.region.getRight(); ++column) {
                IGridRegion mergedRegion = grid.getRegionStartingAt(column, row);
                if (mergedRegion == null || IGridRegion.Tool.width(mergedRegion) <= 1) continue;
                this.removedRegions.add(mergedRegion);
                grid.removeMergedRegion(mergedRegion);
                for (int i = mergedRegion.getLeft(); i <= mergedRegion.getRight(); ++i) {
                    GridRegion newRegion = new GridRegion(mergedRegion.getTop(), i, mergedRegion.getBottom(), i);
                    grid.addMergedRegion(newRegion);
                    this.createdRegions.add(newRegion);
                }
                column = mergedRegion.getRight();
            }
        }
    }

    @Override
    public void undoAction(IGridTable table) {
        IWritableGrid grid = (IWritableGrid)table.getGrid();
        for (IGridRegion region : this.createdRegions) {
            grid.removeMergedRegion(region);
        }
        for (IGridRegion region : this.removedRegions) {
            grid.addMergedRegion(region);
        }
    }
}

