/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

public abstract class Point {
    private static final byte MAX_COLUMN = 10;
    private static final byte MAX_ROW = 100;
    private static final Point[][] POINTS = new Point[10][100];

    private Point() {
    }

    public static Point get(int column, int row) {
        if (column < 10 && row < 100) {
            return POINTS[column][row];
        }
        if ((column & 0xFFFFFF00 | row & 0xFF000000) == 0) {
            return new CompressedPoint(column, row);
        }
        return new BigPoint(column, row);
    }

    public abstract int getColumn();

    public abstract int getRow();

    static {
        for (byte i = 0; i < 10; i = (byte)((byte)(i + 1))) {
            for (byte j = 0; j < 100; j = (byte)(j + 1)) {
                final byte column = i;
                final byte row = j;
                Point.POINTS[i][j] = new Point(){

                    @Override
                    public int getColumn() {
                        return column;
                    }

                    @Override
                    public int getRow() {
                        return row;
                    }
                };
            }
        }
    }

    private static final class BigPoint
    extends Point {
        final int column;
        final int row;

        private BigPoint(int column, int row) {
            this.column = column;
            this.row = row;
        }

        @Override
        public int getColumn() {
            return this.column;
        }

        @Override
        public int getRow() {
            return this.row;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BigPoint bigPoint = (BigPoint)o;
            return this.column == bigPoint.column && this.row == bigPoint.row;
        }

        public int hashCode() {
            return 31 * this.column + this.row;
        }
    }

    private static final class CompressedPoint
    extends Point {
        private final int compressed;

        CompressedPoint(int column, int row) {
            this.compressed = row | column << 24;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.compressed == ((CompressedPoint)o).compressed;
        }

        public int hashCode() {
            return this.compressed;
        }

        @Override
        public int getColumn() {
            return (this.compressed & 0xFF000000) >> 24;
        }

        @Override
        public int getRow() {
            return this.compressed & 0xFFFFFF;
        }
    }
}

