/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.table;

import org.openl.rules.table.IGridTable;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.table.LogicalTableHelper;

public abstract class ALogicalTable
implements ILogicalTable {
    private final IGridTable table;

    public ALogicalTable(IGridTable table) {
        this.table = table;
    }

    @Override
    public IGridTable getSource() {
        return this.table;
    }

    @Override
    public ILogicalTable getColumn(int column) {
        return (ILogicalTable)this.getSubtable(column, 0, 1, this.getHeight());
    }

    @Override
    public ILogicalTable getColumns(int from) {
        return this.getColumns(from, this.getWidth() - 1);
    }

    @Override
    public ILogicalTable getColumns(int from, int to) {
        int colsNum = to - from + 1;
        return (ILogicalTable)this.getSubtable(from, 0, colsNum, this.getHeight());
    }

    @Override
    public ILogicalTable getRow(int row) {
        return (ILogicalTable)this.getSubtable(0, row, this.getWidth(), 1);
    }

    @Override
    public ILogicalTable getRows(int from) {
        return this.getRows(from, this.getHeight() - 1);
    }

    @Override
    public ILogicalTable getRows(int from, int to) {
        int rowsNum = to - from + 1;
        return (ILogicalTable)this.getSubtable(0, from, this.getWidth(), rowsNum);
    }

    @Override
    public ILogicalTable transpose() {
        return LogicalTableHelper.logicalTable((IGridTable)this.getSource().transpose());
    }

    @Override
    public boolean isNormalOrientation() {
        return this.getSource().isNormalOrientation();
    }

    public String toString() {
        StringBuilder tableVisualization = new StringBuilder();
        tableVisualization.append(super.toString()).append("(").append(this.getWidth()).append(" x ").append(this.getHeight()).append(")").append("\n");
        for (int i = 0; i < this.getSource().getHeight(); ++i) {
            int length = 0;
            for (int j = 0; j < this.getSource().getWidth(); ++j) {
                String stringValue = this.getSource().getCell(j, i).getStringValue();
                if (stringValue == null) {
                    stringValue = "EMPTY";
                }
                length += stringValue.length();
                tableVisualization.append(stringValue);
                tableVisualization.append("|");
            }
            tableVisualization.append("\n");
            for (int k = 0; k <= length; ++k) {
                tableVisualization.append("-");
            }
            tableVisualization.append("\n");
        }
        return tableVisualization.toString();
    }
}

