/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.types.meta;

import java.util.HashMap;
import java.util.Map;
import org.openl.rules.lang.xls.types.CellMetaInfo;
import org.openl.rules.lang.xls.types.meta.MetaInfoReader;
import org.openl.rules.lang.xls.types.meta.MetaInfoWriter;
import org.openl.rules.table.CellKey;
import org.openl.rules.table.GridTableUtils;
import org.openl.rules.table.IGridRegion;
import org.openl.rules.table.IGridTable;

public class MetaInfoWriterImpl
implements MetaInfoWriter {
    private final Map<CellKey, CellMetaInfo> metaInfoMap = new HashMap<CellKey, CellMetaInfo>();

    public MetaInfoWriterImpl(MetaInfoReader delegate, IGridTable gridTable) {
        IGridRegion region = GridTableUtils.getOriginalTable(gridTable).getRegion();
        int top = region.getTop();
        int left = region.getLeft();
        int bottom = region.getBottom();
        int right = region.getRight();
        for (int row = top; row <= bottom; ++row) {
            for (int col = left; col <= right; ++col) {
                CellKey key = CellKey.CellKeyFactory.getCellKey(col, row);
                this.metaInfoMap.put(key, delegate.getMetaInfo(row, col));
            }
        }
    }

    @Override
    public void setMetaInfo(int row, int col, CellMetaInfo metaInfo) {
        CellKey key = CellKey.CellKeyFactory.getCellKey(col, row);
        if (metaInfo == null) {
            this.metaInfoMap.remove(key);
        } else {
            this.metaInfoMap.put(key, metaInfo);
        }
    }

    @Override
    public CellMetaInfo getMetaInfo(int row, int col) {
        CellKey key = CellKey.CellKeyFactory.getCellKey(col, row);
        return this.metaInfoMap.get(key);
    }

    @Override
    public void prepare(IGridRegion region) {
    }

    @Override
    public void release() {
    }
}

