/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.load;

import org.apache.poi.ss.usermodel.Workbook;
import org.openl.rules.lang.xls.SpreadsheetConstants;
import org.openl.rules.lang.xls.load.SheetLoader;
import org.openl.rules.lang.xls.load.SimpleSheetLoader;
import org.openl.rules.lang.xls.load.WorkbookLoader;

public class SimpleWorkbookLoader
implements WorkbookLoader {
    private final Workbook workbook;
    private final SpreadsheetConstants spreadsheetConstants;

    public SimpleWorkbookLoader(Workbook workbook) {
        this.workbook = workbook;
        this.spreadsheetConstants = new SpreadsheetConstants(workbook.getSpreadsheetVersion());
    }

    @Override
    public Workbook getWorkbook() {
        return this.workbook;
    }

    @Override
    public SheetLoader getSheetLoader(int sheetIndex) {
        return new SimpleSheetLoader(this.workbook.getSheetAt(sheetIndex));
    }

    @Override
    public int getNumberOfSheets() {
        return this.workbook.getNumberOfSheets();
    }

    @Override
    public boolean isCanUnload() {
        return false;
    }

    @Override
    public void setCanUnload(boolean canUnload) {
    }

    @Override
    public SpreadsheetConstants getSpreadsheetConstants() {
        return this.spreadsheetConstants;
    }
}

