/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.lang.xls.load;

import org.openl.rules.lang.xls.load.GreedyLazyWorkbookLoader;
import org.openl.rules.lang.xls.load.UnloadableLazyWorkbookLoader;
import org.openl.rules.lang.xls.load.WorkbookLoader;
import org.openl.rules.lang.xls.load.WorkbookLoaderFactory;
import org.openl.source.IOpenSourceCodeModule;

public class LazyWorkbookLoaderFactory
implements WorkbookLoaderFactory {
    private final boolean canUnload;

    public LazyWorkbookLoaderFactory(boolean canUnload) {
        this.canUnload = canUnload;
    }

    @Override
    public WorkbookLoader createWorkbookLoader(IOpenSourceCodeModule fileSource) {
        return this.canUnload ? new UnloadableLazyWorkbookLoader(fileSource) : new GreedyLazyWorkbookLoader(fileSource);
    }
}

