/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;

public final class NumberUtils {
    private NumberUtils() {
    }

    public static boolean isObjectFloatPointNumber(Object value) {
        if (value != null) {
            return NumberUtils.isFloatPointType(value.getClass());
        }
        return false;
    }

    public static boolean isFloatPointType(Class<?> cls) {
        return cls != null && (Float.TYPE == cls || Double.TYPE == cls || Float.class == cls || Double.class == cls || BigDecimal.class.isAssignableFrom(cls));
    }

    public static boolean isNonFloatPointType(Class<?> cls) {
        return cls != null && (Byte.TYPE == cls || Short.TYPE == cls || Integer.TYPE == cls || Long.TYPE == cls || Byte.class == cls || Short.class == cls || Integer.class == cls || Long.class == cls || BigInteger.class == cls);
    }

    public static Double convertToDouble(Object object) {
        if (object instanceof Float) {
            return Double.parseDouble(object.toString());
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof BigDecimal) {
            return ((BigDecimal)object).doubleValue();
        }
        if (object instanceof Byte) {
            return ((Byte)object).doubleValue();
        }
        if (object instanceof Short) {
            return ((Short)object).doubleValue();
        }
        if (object instanceof Integer) {
            return ((Integer)object).doubleValue();
        }
        if (object instanceof Long) {
            return ((Long)object).doubleValue();
        }
        if (object instanceof BigInteger) {
            return ((BigInteger)object).doubleValue();
        }
        return null;
    }

    public static Double roundValue(Double value, int scale) {
        if (value != null) {
            if (value.isInfinite() || value.isNaN()) {
                return value;
            }
            BigDecimal roundedValue = BigDecimal.valueOf(value);
            roundedValue = roundedValue.setScale(scale, RoundingMode.HALF_UP);
            return roundedValue.doubleValue();
        }
        return null;
    }

    public static int getScale(Number value) {
        if (value == null) {
            throw new NullPointerException("Null value is not supported");
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).scale();
        }
        if (NumberUtils.isObjectFloatPointNumber(value)) {
            return NumberUtils.getScale(NumberUtils.convertToDouble(value));
        }
        return BigDecimal.valueOf(value.longValue()).scale();
    }

    public static int getScale(double value) {
        if (!Double.isNaN(value) && !Double.isInfinite(value)) {
            BigDecimal decimal = BigDecimal.valueOf(value);
            return decimal.scale();
        }
        return 0;
    }

    public static int getScale(float value) {
        return NumberUtils.getScale(Double.parseDouble(Float.toString(value)));
    }

    public static boolean isNumberType(Class<?> cls) {
        return NumberUtils.isFloatPointType(cls) || NumberUtils.isNonFloatPointType(cls);
    }
}

