/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.helpers;

import java.text.ParseException;
import java.util.regex.Pattern;
import org.openl.rules.range.RangeParser;

public class DateRangeParser {
    private static final Pattern SIMPLE_PATTERN = Pattern.compile("\\d{1,2}/\\d{1,2}/\\d+(?: \\d{1,2}:\\d{1,2}:\\d{1,2})?");

    private DateRangeParser() {
    }

    public static DateRangeParser getInstance() {
        return InstanceHolder.INSTANCE;
    }

    public boolean likelyRangeThanDate(String value) {
        try {
            RangeParser rangeParser = RangeParser.parse(value);
            if (rangeParser == null) {
                return false;
            }
            String left = rangeParser.getLeft();
            if (left != null && !SIMPLE_PATTERN.matcher(left).matches()) {
                return false;
            }
            String right = rangeParser.getRight();
            return right == null || SIMPLE_PATTERN.matcher(right).matches();
        }
        catch (ParseException e) {
            return false;
        }
    }

    private static final class InstanceHolder {
        private static final DateRangeParser INSTANCE = new DateRangeParser();

        private InstanceHolder() {
        }
    }
}

