/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.storage;

import java.util.Map;
import org.openl.rules.dt.storage.ByteExtMappedStorage;
import org.openl.rules.dt.storage.ByteMappedStorage;
import org.openl.rules.dt.storage.EmptyStorage;
import org.openl.rules.dt.storage.IStorage;
import org.openl.rules.dt.storage.IntMappedStorage;
import org.openl.rules.dt.storage.ObjectStorage;
import org.openl.rules.dt.storage.ShortExtMappedStorage;
import org.openl.rules.dt.storage.ShortMappedStorage;
import org.openl.rules.dt.storage.StorageBuilder;

public class ObjectStorageBuilder
extends StorageBuilder<Object> {
    private static final int MIN_MAPPED_SIZE = 16;
    final ObjectStorage storage;

    ObjectStorageBuilder(int size) {
        this.storage = new ObjectStorage(size);
    }

    @Override
    public void writeValue(Object value, int index) {
        this.storage.setValue(index, value);
    }

    @Override
    public void writeSpace(int index) {
        this.storage.setSpace(index);
    }

    @Override
    public void writeElse(int index) {
        this.storage.setElse(index);
    }

    @Override
    public void writeFormula(Object formula, int index) {
        this.storage.setFormula(index, formula);
    }

    @Override
    public IStorage<Object> optimizeAndBuild() {
        if (this.storage.size() == 0) {
            return new EmptyStorage(this.info);
        }
        if (!this.shouldUseMappedStorage()) {
            this.storage.setInfo(this.info);
            return this.storage;
        }
        int size = this.storage.size();
        int[] map = new int[size];
        Object[] uniqueValues = new Object[this.info.getTotalNumberOfUniqueValues()];
        int firstFormulaIndex = this.info.getUniqueIndex().size();
        int spaceIndex = this.info.getNumberOfFormulas() + firstFormulaIndex;
        int elseIndex = this.info.getNumberOfSpaces() == 0 ? spaceIndex : spaceIndex + 1;
        for (Map.Entry<Object, Integer> e : this.info.getUniqueIndex().entrySet()) {
            uniqueValues[e.getValue().intValue()] = e.getKey();
        }
        int formulaCnt = 0;
        for (int i = 0; i < size; ++i) {
            if (this.storage.isElse(i)) {
                map[i] = elseIndex;
                if (elseIndex >= uniqueValues.length) continue;
                uniqueValues[elseIndex] = IStorage.StorageType.ELSE;
                continue;
            }
            if (this.storage.isSpace(i)) {
                map[i] = spaceIndex;
                if (spaceIndex >= uniqueValues.length) continue;
                uniqueValues[spaceIndex] = null;
                continue;
            }
            if (this.storage.isFormula(i)) {
                map[i] = firstFormulaIndex + formulaCnt++;
                if (map[i] >= uniqueValues.length) continue;
                uniqueValues[map[i]] = this.storage.getValue(i);
                continue;
            }
            Object value = this.storage.getValue(i);
            map[i] = this.info.getUniqueIndex().get(value);
        }
        int mapMaxValue = uniqueValues.length - 1;
        if (mapMaxValue <= 127) {
            return new ByteMappedStorage(map, uniqueValues, this.info);
        }
        if (mapMaxValue <= 255) {
            return new ByteExtMappedStorage(map, uniqueValues, this.info);
        }
        if (mapMaxValue <= Short.MAX_VALUE) {
            return new ShortMappedStorage(map, uniqueValues, this.info);
        }
        if (mapMaxValue <= 65535) {
            return new ShortExtMappedStorage(map, uniqueValues, this.info);
        }
        return new IntMappedStorage(map, uniqueValues, this.info);
    }

    private boolean shouldUseMappedStorage() {
        if (this.size() < 16) {
            return false;
        }
        double uniqueValues = this.info.getTotalNumberOfUniqueValues();
        return uniqueValues / (double)this.size() < 0.7 && uniqueValues > 0.0;
    }

    @Override
    protected void checkMinMax(Object loadedValue) {
    }

    @Override
    public int size() {
        return this.storage.size();
    }
}

