/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.element;

import java.lang.reflect.Array;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.openl.OpenL;
import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetResultOpenClass;
import org.openl.rules.dt.DTScale;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.data.RuleExecutionObject;
import org.openl.rules.dt.element.ActionType;
import org.openl.rules.dt.element.DTColumnSpreadsheetResultOpenClass;
import org.openl.rules.dt.element.FunctionalRow;
import org.openl.rules.dt.element.IAction;
import org.openl.rules.dt.element.RuleRow;
import org.openl.rules.enumeration.DTEmptyResultProcessingEnum;
import org.openl.rules.lang.xls.binding.wrapper.IRulesMethodWrapper;
import org.openl.rules.lang.xls.binding.wrapper.WrapperLogic;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.table.ILogicalTable;
import org.openl.rules.vm.SimpleRulesRuntimeEnv;
import org.openl.source.IOpenSourceCodeModule;
import org.openl.source.impl.StringSourceCodeModule;
import org.openl.syntax.ISyntaxNode;
import org.openl.types.IDynamicObject;
import org.openl.types.IMethodSignature;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.IParameterDeclaration;
import org.openl.types.NullParameterDeclaration;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.impl.ParameterDeclaration;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;
import org.openl.util.StringUtils;
import org.openl.vm.IRuntimeEnv;

public class Action
extends FunctionalRow
implements IAction {
    private static final String EXTRA_RET = "e$x$t$r$a$R$e$t";
    private boolean isSingleReturnParam;
    private IOpenClass returnType;
    private IOpenClass singleActionReturnType;
    private int singleActionReturnTypeDim;
    private final ActionType actionType;
    private final boolean skipEmptyResult;

    public Action(String name, int row, ILogicalTable decisionTable, ActionType actionType, DTScale.RowScale scale, DecisionTable decisionTableInvocableMethod) {
        super(name, row, decisionTable, scale);
        this.actionType = actionType;
        this.skipEmptyResult = decisionTableInvocableMethod.getMethodProperties() != null && DTEmptyResultProcessingEnum.SKIP.equals((Object)decisionTableInvocableMethod.getMethodProperties().getEmptyResultProcessing());
    }

    @Override
    public boolean isAction() {
        return true;
    }

    @Override
    public boolean isCondition() {
        return false;
    }

    @Override
    public boolean isReturnAction() {
        return ActionType.RETURN == this.actionType;
    }

    @Override
    public boolean isCollectReturnKeyAction() {
        return ActionType.COLLECT_RETURN_KEY == this.actionType;
    }

    @Override
    public boolean isCollectReturnAction() {
        return ActionType.COLLECT_RETURN == this.actionType;
    }

    @Override
    public Object executeAction(int ruleN, Object target, Object[] params, IRuntimeEnv env) {
        if (target instanceof IDynamicObject) {
            target = new RuleExecutionObject(this.ruleExecutionType, (IDynamicObject)target, ruleN);
        }
        if (this.isSingleReturnParam) {
            if (this.skipEmptyResult && this.isEmpty(ruleN)) {
                return null;
            }
            Object[] dest = new Object[this.getNumberOfParams()];
            this.loadValues(dest, 0, ruleN, target, params, env);
            Object returnValue = dest[0];
            CompositeMethod method = this.getMethod();
            IOpenClass methodType = method.getType();
            if (returnValue == null || ClassUtils.isAssignable(returnValue.getClass(), (Class)methodType.getInstanceClass())) {
                return this.ifSpreadsheetResultUseDTSprType(returnValue, env);
            }
            return this.ifSpreadsheetResultUseDTSprType(this.executeActionInternal(ruleN, target, params, env), env);
        }
        return this.ifSpreadsheetResultUseDTSprType(this.executeActionInternal(ruleN, target, params, env), env);
    }

    private void setCustomSpreadsheetResultOpenClassToArray(Object o, int dimension, CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass) {
        block5: {
            if (o == null) {
                return;
            }
            if (dimension <= 0) break block5;
            int size = Array.getLength(o);
            if (dimension == 1) {
                for (int i = 0; i < size; ++i) {
                    Object v = Array.get(o, i);
                    Object g = this.setCustomSpreadsheetResultOpenClassToArray(v, customSpreadsheetResultOpenClass);
                    Array.set(o, i, g);
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    this.setCustomSpreadsheetResultOpenClassToArray(Array.get(o, i), dimension - 1, customSpreadsheetResultOpenClass);
                }
            }
        }
    }

    private Object setCustomSpreadsheetResultOpenClassToArray(Object e, CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass) {
        if (e instanceof SpreadsheetResult) {
            SpreadsheetResult spreadsheetResult = (SpreadsheetResult)e;
            SpreadsheetResult newSpreadsheetResult = new SpreadsheetResult(spreadsheetResult);
            newSpreadsheetResult.setCustomSpreadsheetResultOpenClass(customSpreadsheetResultOpenClass);
            return newSpreadsheetResult;
        }
        return e;
    }

    private Object ifSpreadsheetResultUseDTSprType(Object value, IRuntimeEnv env) {
        if (this.singleActionReturnType instanceof CustomSpreadsheetResultOpenClass) {
            SimpleRulesRuntimeEnv simpleRulesRuntimeEnv = WrapperLogic.extractSimpleRulesRuntimeEnv(env);
            IRulesMethodWrapper methodWrapper = simpleRulesRuntimeEnv.getMethodWrapper();
            IOpenClass t = methodWrapper.getType();
            if (t.isArray()) {
                t = t.getComponentClass();
            }
            if (this.singleActionReturnTypeDim == 0) {
                return this.setCustomSpreadsheetResultOpenClassToArray(value, (CustomSpreadsheetResultOpenClass)t);
            }
            this.setCustomSpreadsheetResultOpenClassToArray(value, this.singleActionReturnTypeDim, (CustomSpreadsheetResultOpenClass)t);
            return value;
        }
        return value;
    }

    private Object executeActionInternal(int ruleN, Object target, Object[] params, IRuntimeEnv env) {
        if (this.skipEmptyResult && this.isEmpty(ruleN)) {
            return null;
        }
        return this.getMethod().invoke(target, this.mergeParams(target, params, env, ruleN), env);
    }

    private static IOpenClass extractMethodTypeForCollectReturnKeyAction(TableSyntaxNode tableSyntaxNode, IBindingContext bindingContext) {
        JavaOpenClass cType = null;
        if (tableSyntaxNode.getHeader().getCollectParameters().length > 0) {
            cType = bindingContext.findType("org.openl.this", tableSyntaxNode.getHeader().getCollectParameters()[0]);
        }
        return cType != null ? cType : JavaOpenClass.OBJECT;
    }

    private static IOpenClass extractMethodTypeForCollectReturnAction(TableSyntaxNode tableSyntaxNode, IOpenClass type, IBindingContext bindingContext) {
        if (type.isArray()) {
            return type.getComponentClass();
        }
        if (ClassUtils.isAssignable((Class)type.getInstanceClass(), Collection.class)) {
            JavaOpenClass cType = null;
            if (tableSyntaxNode.getHeader().getCollectParameters().length > 0) {
                cType = bindingContext.findType("org.openl.this", tableSyntaxNode.getHeader().getCollectParameters()[0]);
            }
            return cType != null ? cType : JavaOpenClass.OBJECT;
        }
        if (ClassUtils.isAssignable((Class)type.getInstanceClass(), Map.class)) {
            JavaOpenClass cType = null;
            if (tableSyntaxNode.getHeader().getCollectParameters().length > 1) {
                cType = bindingContext.findType("org.openl.this", tableSyntaxNode.getHeader().getCollectParameters()[1]);
            }
            return cType != null ? cType : JavaOpenClass.OBJECT;
        }
        return type;
    }

    @Override
    public void prepareAction(DecisionTable decisionTable, IOpenMethodHeader header, IMethodSignature signature, OpenL openl, IBindingContext bindingContext, RuleRow ruleRow, IOpenClass ruleExecutionType, TableSyntaxNode tableSyntaxNode) throws Exception {
        IOpenClass t;
        Object methodType = JavaOpenClass.VOID;
        if (this.isReturnAction()) {
            methodType = header.getType();
            if (decisionTable.isTypeCustomSpreadsheetResult()) {
                methodType = decisionTable.getDim() > 0 ? DTColumnSpreadsheetResultOpenClass.INSTANCE.getArrayType(decisionTable.getDim()) : DTColumnSpreadsheetResultOpenClass.INSTANCE;
            }
        } else if (this.isCollectReturnAction()) {
            methodType = Action.extractMethodTypeForCollectReturnAction(tableSyntaxNode, header.getType(), bindingContext);
        } else if (this.isCollectReturnKeyAction()) {
            methodType = Action.extractMethodTypeForCollectReturnKeyAction(tableSyntaxNode, bindingContext);
        }
        this.prepare(decisionTable, (IOpenClass)methodType, signature, openl, bindingContext, ruleRow, ruleExecutionType, tableSyntaxNode);
        IParameterDeclaration[] params = this.getParams();
        CompositeMethod method = this.getMethod();
        String code = Optional.ofNullable(method.getMethodBodyBoundNode()).map(IBoundNode::getSyntaxNode).map(ISyntaxNode::getModule).map(IOpenSourceCodeModule::getCode).orElse(null);
        boolean bl = this.isSingleReturnParam = params.length == 1 && !NullParameterDeclaration.isAnyNull((IParameterDeclaration[])new IParameterDeclaration[]{params[0]}) && params[0].getName().equals(code);
        if ((this.isReturnAction() || this.isCollectReturnAction()) && decisionTable.isTypeCustomSpreadsheetResult() && (t = method.getBodyType()) != null) {
            while (t.isArray()) {
                t = t.getComponentClass();
            }
            IOpenClass g = t;
            decisionTable.getDeferredChanges().add(() -> {
                if (g instanceof CustomSpreadsheetResultOpenClass || g instanceof SpreadsheetResultOpenClass) {
                    decisionTable.getCustomSpreadsheetResultType().updateWithType(g);
                }
            });
        }
        this.returnType = decisionTable.getType();
        if (this.isReturnAction()) {
            this.singleActionReturnType = decisionTable.getType();
        } else if (this.isCollectReturnAction()) {
            this.singleActionReturnType = Action.extractMethodTypeForCollectReturnAction(tableSyntaxNode, decisionTable.getType(), bindingContext);
        }
        this.singleActionReturnTypeDim = 0;
        while (this.singleActionReturnType != null && this.singleActionReturnType.isArray()) {
            this.singleActionReturnType = this.singleActionReturnType.getComponentClass();
            ++this.singleActionReturnTypeDim;
        }
    }

    @Override
    public IOpenClass getType() {
        return this.returnType;
    }

    @Override
    protected void prepareParams(IOpenClass declaringClass, IMethodSignature signature, IOpenClass methodType, IOpenSourceCodeModule methodSource, OpenL openl, IBindingContext bindingContext) throws Exception {
        if (EXTRA_RET.equals(methodSource.getCode()) && (this.isReturnAction() || this.isCollectReturnAction() || this.isCollectReturnKeyAction())) {
            ParameterDeclaration extraParam = new ParameterDeclaration(methodType, EXTRA_RET);
            this.params = new IParameterDeclaration[]{extraParam};
            this.paramInitialized = new BitSet(1);
            this.paramInitialized.set(0);
            this.paramsUniqueNames = new HashSet();
            this.paramsUniqueNames.add(extraParam.getName());
        } else {
            super.prepareParams(declaringClass, signature, methodType, methodSource, openl, bindingContext);
        }
    }

    @Override
    protected IOpenSourceCodeModule getExpressionSource(TableSyntaxNode tableSyntaxNode, IMethodSignature signature, IOpenClass methodType, IOpenClass declaringClass, OpenL openl, IBindingContext bindingContext) throws Exception {
        IOpenSourceCodeModule source = super.getExpressionSource(tableSyntaxNode, signature, methodType, declaringClass, openl, bindingContext);
        if ((this.isReturnAction() || this.isCollectReturnAction() || this.isCollectReturnKeyAction()) && StringUtils.isEmpty((CharSequence)source.getCode())) {
            if (this.hasDeclaredParams()) {
                super.prepareParams(declaringClass, signature, methodType, null, openl, bindingContext);
                return new StringSourceCodeModule(this.params[0].getName() != null ? this.params[0].getName() : EXTRA_RET, source.getUri());
            }
            return new StringSourceCodeModule(EXTRA_RET, source.getUri());
        }
        return source;
    }
}

