/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.openl.OpenL;
import org.openl.binding.exception.AmbiguousFieldException;
import org.openl.binding.impl.component.ComponentOpenClass;
import org.openl.rules.dt.DecisionTable;
import org.openl.rules.dt.IBaseCondition;
import org.openl.rules.dt.IBaseDecisionRow;
import org.openl.rules.dt.data.ConditionOrActionDataType;
import org.openl.rules.dt.data.ConditionOrActionDirectParameterField;
import org.openl.rules.dt.data.DecisionExprField;
import org.openl.rules.dt.data.DecisionRowField;
import org.openl.rules.dt.data.DecisionRuleIdField;
import org.openl.rules.dt.data.DecisionRuleNameField;
import org.openl.rules.dt.element.IDecisionRow;
import org.openl.types.IOpenField;
import org.openl.types.IParameterDeclaration;

public class DecisionTableDataType
extends ComponentOpenClass {
    private final Map<String, List<IOpenField>> nonConflictConditionParamNames = new HashMap<String, List<IOpenField>>();
    private final Map<String, List<IOpenField>> nonConflictConditionParamNamesNonStrictMatch = new HashMap<String, List<IOpenField>>();
    private Set<IOpenField> usedFields;
    private final boolean traceUsedFields;

    public DecisionTableDataType(DecisionTable decisionTable, String name, OpenL openl, boolean traceUsedFields) {
        super(name, openl);
        this.traceUsedFields = traceUsedFields;
        if (traceUsedFields) {
            this.usedFields = new HashSet<IOpenField>();
        }
        if (decisionTable != null) {
            for (IBaseCondition iBaseCondition : decisionTable.getConditionRows()) {
                this.addParameterFields(decisionTable, (IDecisionRow)((Object)iBaseCondition));
            }
            for (IBaseDecisionRow iBaseDecisionRow : decisionTable.getActionRows()) {
                this.addParameterFields(decisionTable, (IDecisionRow)iBaseDecisionRow);
            }
        }
        this.addField(new DecisionExprField(this, openl));
        this.addField(new DecisionRuleIdField(this));
        this.addField(new DecisionRuleNameField(this, decisionTable != null ? decisionTable.getRuleRow() : null));
    }

    public IOpenField getField(String fname, boolean strictMatch) throws AmbiguousFieldException {
        if (fname == null) {
            return null;
        }
        List<IOpenField> conditionParameterFields = strictMatch ? this.nonConflictConditionParamNames.get(fname) : this.nonConflictConditionParamNamesNonStrictMatch.get(fname.toLowerCase());
        if (conditionParameterFields != null && !conditionParameterFields.isEmpty()) {
            if (conditionParameterFields.size() == 1) {
                IOpenField f = conditionParameterFields.iterator().next();
                if (this.traceUsedFields) {
                    this.usedFields.add(f);
                }
                return f;
            }
            List decisionRowFields = conditionParameterFields.stream().filter(e -> e instanceof DecisionRowField).collect(Collectors.toList());
            if (decisionRowFields.size() != 1) {
                throw new AmbiguousFieldException(fname, conditionParameterFields);
            }
            IOpenField f = (IOpenField)decisionRowFields.iterator().next();
            if (this.traceUsedFields) {
                this.usedFields.add(f);
            }
            return f;
        }
        return super.getField(fname, strictMatch);
    }

    public void addDecisionTableField(IOpenField f) {
        if (f != null) {
            this.nonConflictConditionParamNames.computeIfAbsent(f.getName(), e -> new ArrayList()).add(f);
            this.nonConflictConditionParamNamesNonStrictMatch.computeIfAbsent(f.getName().toLowerCase(), e -> new ArrayList()).add(f);
        }
    }

    public void resetLowerCasedUsedFields() {
        if (this.traceUsedFields) {
            this.usedFields = new HashSet<IOpenField>();
        }
    }

    public Set<IOpenField> getUsedFields() {
        return this.usedFields;
    }

    private void addParameterFields(DecisionTable decisionTable, IDecisionRow decisionRow) {
        ConditionOrActionDataType dataType = new ConditionOrActionDataType(decisionRow, this.getOpenl());
        DecisionRowField decisionRowField = new DecisionRowField(decisionTable, decisionRow, dataType, this);
        this.addDecisionTableField(decisionRowField);
        IParameterDeclaration[] pdd = decisionRow.getParams();
        for (int i = 0; i < pdd.length; ++i) {
            if (pdd[i] == null) continue;
            ConditionOrActionDirectParameterField f = new ConditionOrActionDirectParameterField(decisionTable, decisionRow, i, this);
            this.addDecisionTableField(f);
        }
    }
}

