/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm.evaluator;

import java.util.ArrayList;
import java.util.List;
import org.openl.domain.IIntIterator;
import org.openl.rules.dt.DecisionTableRuleNodeBuilder;
import org.openl.rules.dt.algorithm.evaluator.ARangeIndexEvaluator;
import org.openl.rules.dt.element.ConditionCasts;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.index.IRuleIndex;
import org.openl.rules.dt.index.RangeAscIndex;
import org.openl.rules.dt.index.RangeDescIndex;
import org.openl.rules.dt.type.IRangeAdaptor;

public class SingleRangeIndexEvaluator
extends ARangeIndexEvaluator {
    public SingleRangeIndexEvaluator(IRangeAdaptor<Object, ? extends Comparable<Object>> rangeAdaptor, ConditionCasts conditionCasts) {
        super(rangeAdaptor, 1, conditionCasts);
    }

    @Override
    public IRuleIndex makeIndex(ICondition condition, IIntIterator it) {
        if (it.size() < 1) {
            return null;
        }
        ArrayList<ARangeIndexEvaluator.IndexNode> nodes = new ArrayList<ARangeIndexEvaluator.IndexNode>(it.size());
        DecisionTableRuleNodeBuilder emptyRulesBuilder = new DecisionTableRuleNodeBuilder();
        DecisionTableRuleNodeBuilder nextNodeBuilder = new DecisionTableRuleNodeBuilder();
        boolean isNaturalOrder = true;
        while (it.hasNext()) {
            int ruleN = it.nextInt();
            nextNodeBuilder.addRule(ruleN);
            if (condition.isEmpty(ruleN)) {
                emptyRulesBuilder.addRule(ruleN);
                continue;
            }
            Object origVal = condition.getParamValue(0, ruleN);
            Object vFrom = this.rangeAdaptor.getMin(origVal);
            Object vTo = this.rangeAdaptor.getMax(origVal);
            if (vFrom != null) {
                nodes.add(new ARangeIndexEvaluator.IndexNode((Comparable<Object>)vFrom, ruleN));
                isNaturalOrder = true;
                continue;
            }
            if (vTo == null) continue;
            nodes.add(new ARangeIndexEvaluator.IndexNode((Comparable<Object>)vTo, ruleN));
            isNaturalOrder = false;
        }
        List<ARangeIndexEvaluator.IndexNode> result = this.mergeRulesByValue(nodes);
        ARangeIndexEvaluator.RangeIndexNodeAdaptor indexNodeAdaptor = new ARangeIndexEvaluator.RangeIndexNodeAdaptor(this.rangeAdaptor);
        int[] emptyRules = emptyRulesBuilder.makeNode().getRules();
        if (isNaturalOrder) {
            return new RangeAscIndex(nextNodeBuilder.makeNode(), result, indexNodeAdaptor, emptyRules);
        }
        return new RangeDescIndex(nextNodeBuilder.makeNode(), result, indexNodeAdaptor, emptyRules);
    }
}

