/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm.evaluator;

import java.math.BigDecimal;
import org.openl.domain.IIntSelector;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.helpers.NumberUtils;
import org.openl.vm.IRuntimeEnv;

public class EqualsSelector
implements IIntSelector {
    private final ICondition condition;
    private final Object value;
    private final Object target;
    private final Object[] params;
    private final IRuntimeEnv env;

    EqualsSelector(ICondition condition, Object value, Object target, Object[] params, IRuntimeEnv env) {
        this.condition = condition;
        this.value = value;
        this.params = params;
        this.env = env;
        this.target = target;
    }

    public boolean select(int ruleN) {
        if (this.condition.isEmpty(ruleN)) {
            return true;
        }
        Object[] realParams = new Object[this.condition.getNumberOfParams()];
        this.condition.loadValues(realParams, 0, ruleN, this.target, this.params, this.env);
        if (realParams[0] == null) {
            return this.value == null;
        }
        if (this.value instanceof BigDecimal && realParams[0] instanceof BigDecimal) {
            return ((BigDecimal)this.value).compareTo((BigDecimal)realParams[0]) == 0;
        }
        if (this.value instanceof BigDecimal && NumberUtils.isObjectFloatPointNumber(realParams[0])) {
            Double d = NumberUtils.convertToDouble(realParams[0]);
            return ((BigDecimal)this.value).compareTo(BigDecimal.valueOf(d)) == 0;
        }
        if (NumberUtils.isObjectFloatPointNumber(this.value) && realParams[0] instanceof BigDecimal) {
            Double d = NumberUtils.convertToDouble(this.value);
            return ((BigDecimal)realParams[0]).compareTo(BigDecimal.valueOf(d)) == 0;
        }
        return realParams[0].equals(this.value);
    }
}

