/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.dt.algorithm.evaluator;

import java.math.BigDecimal;
import java.util.AbstractSet;
import java.util.HashSet;
import java.util.TreeSet;
import org.openl.domain.IIntIterator;
import org.openl.rules.dt.algorithm.evaluator.AEqualsIndexedEvaluator;
import org.openl.rules.dt.algorithm.evaluator.FloatTypeComparator;
import org.openl.rules.dt.element.ConditionCasts;
import org.openl.rules.dt.element.ICondition;
import org.openl.rules.dt.index.ARuleIndex;
import org.openl.rules.dt.index.EqualsIndex;
import org.openl.rules.helpers.NumberUtils;

public class EqualsIndexedEvaluator
extends AEqualsIndexedEvaluator {
    public EqualsIndexedEvaluator(ConditionCasts conditionCasts) {
        super(conditionCasts);
    }

    @Override
    public ARuleIndex makeIndex(ICondition condition, IIntIterator it) {
        if (it.size() < 1) {
            return null;
        }
        EqualsIndex.Builder builder = new EqualsIndex.Builder();
        builder.setConditionCasts(this.conditionCasts);
        while (it.hasNext()) {
            int ruleN = it.nextInt();
            if (condition.isEmpty(ruleN)) {
                builder.putEmptyRule(ruleN);
                continue;
            }
            Object value = this.conditionCasts.castToInputType(condition.getParamValue(0, ruleN));
            builder.putValueToRule(value, ruleN);
        }
        return builder.build();
    }

    @Override
    public int countUniqueKeys(ICondition condition, IIntIterator it) {
        AbstractSet uniqueVals = null;
        while (it.hasNext()) {
            int i = it.nextInt();
            if (condition.isEmpty(i)) continue;
            Object val = this.conditionCasts.castToInputType(condition.getParamValue(0, i));
            if (uniqueVals == null) {
                uniqueVals = NumberUtils.isObjectFloatPointNumber(val) ? (val instanceof BigDecimal ? new HashSet() : new TreeSet<Object>(FloatTypeComparator.getInstance())) : new HashSet<Object>();
            }
            uniqueVals.add(val);
        }
        return uniqueVals == null ? 0 : uniqueVals.size();
    }

    @Override
    public int getPriority() {
        return 0;
    }
}

