/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import org.openl.rules.convertor.IString2DataConvertor;

public class String2ZonedDateTimeConvertor
implements IString2DataConvertor<ZonedDateTime> {
    private final List<DateTimeFormatter> supportedFormats = new ArrayList<DateTimeFormatter>();

    public String2ZonedDateTimeConvertor() {
        this.supportedFormats.add(DateTimeFormatter.ISO_DATE_TIME);
        this.supportedFormats.add(DateTimeFormatter.ofPattern("M/dd/yyyy H:mm a VV"));
    }

    @Override
    public ZonedDateTime parse(String data, String format) {
        if (data == null) {
            return null;
        }
        for (DateTimeFormatter dtFormat : this.supportedFormats) {
            try {
                return ZonedDateTime.parse(data, dtFormat);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert '%s' to ZonedDateTime type", data));
    }
}

