/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.convertor;

import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import org.openl.rules.convertor.IString2DataConvertor;

public class String2LocalTimeConvertor
implements IString2DataConvertor<LocalTime> {
    private final List<DateTimeFormatter> supportedFormats = new ArrayList<DateTimeFormatter>();

    public String2LocalTimeConvertor() {
        this.supportedFormats.add(DateTimeFormatter.ISO_LOCAL_TIME);
        this.supportedFormats.add(DateTimeFormatter.ofPattern("H:mm a"));
        this.supportedFormats.add(DateTimeFormatter.ofPattern("hh:mm a"));
    }

    @Override
    public LocalTime parse(String data, String format) {
        if (data == null) {
            return null;
        }
        for (DateTimeFormatter dtFormat : this.supportedFormats) {
            try {
                return LocalTime.parse(data, dtFormat);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        throw new IllegalArgumentException(String.format("Cannot convert '%s' to LocalTime type", data));
    }
}

