/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc.result;

import org.openl.binding.impl.cast.IOpenCast;
import org.openl.rules.calc.SpreadsheetResultCalculator;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.result.IResultBuilder;
import org.openl.types.IAggregateInfo;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenIndex;

public class ArrayResultBuilder
implements IResultBuilder {
    private final IOpenClass type;
    private final SpreadsheetCell[] cells;
    private final IOpenCast[] openCasts;
    private final boolean calculateAllCells;

    public ArrayResultBuilder(SpreadsheetCell[] cells, IOpenCast[] openCasts, IOpenClass type, boolean calculateAllCells) {
        this.cells = cells;
        this.openCasts = openCasts;
        this.type = type;
        this.calculateAllCells = calculateAllCells;
    }

    @Override
    public Object buildResult(SpreadsheetResultCalculator resultCalculator) {
        int size = this.cells.length;
        IAggregateInfo aggregateInfo = this.type.getAggregateInfo();
        Object array = aggregateInfo.makeIndexedAggregate(aggregateInfo.getComponentType(this.type), size);
        IOpenIndex index = aggregateInfo.getIndex(this.type);
        Object[][] result = null;
        if (this.calculateAllCells) {
            result = resultCalculator.getValues();
        }
        for (int i = 0; i < size; ++i) {
            SpreadsheetCell cell = this.cells[i];
            Object value = this.calculateAllCells ? result[cell.getRowIndex()][cell.getColumnIndex()] : resultCalculator.getValue(cell.getRowIndex(), cell.getColumnIndex());
            value = value == null ? this.type.nullObject() : this.openCasts[i].convert(value);
            index.setValue(array, (Object)i, value);
        }
        return array;
    }
}

