/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openl.OpenL;
import org.openl.binding.BindingDependencies;
import org.openl.binding.IBindingContext;
import org.openl.binding.impl.BindHelper;
import org.openl.engine.OpenLSystemProperties;
import org.openl.message.OpenLMessagesUtils;
import org.openl.meta.IMetaInfo;
import org.openl.meta.TableMetaInfo;
import org.openl.rules.binding.RulesModuleBindingContextHelper;
import org.openl.rules.calc.CustomSpreadsheetResultField;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.Spreadsheet;
import org.openl.rules.calc.SpreadsheetOpenClass;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.SpreadsheetStructureBuilder;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.lang.xls.binding.AMethodBasedNode;
import org.openl.rules.lang.xls.binding.XlsModuleOpenClass;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.lang.xls.types.meta.SpreadsheetMetaInfoReader;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.ILogicalTable;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.exception.SyntaxNodeException;
import org.openl.syntax.exception.SyntaxNodeExceptionUtils;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenField;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.NullOpenClass;
import org.openl.types.impl.CompositeMethod;
import org.openl.types.java.JavaOpenClass;
import org.openl.util.ClassUtils;

public class SpreadsheetBoundNode
extends AMethodBasedNode {
    private SpreadsheetStructureBuilder structureBuilder;
    private SpreadsheetOpenClass spreadsheetOpenClass;
    private SpreadsheetCell[][] cells;
    private IBindingContext bindingContext;

    public SpreadsheetBoundNode(TableSyntaxNode tableSyntaxNode, OpenL openl, IOpenMethodHeader header, XlsModuleOpenClass module) {
        super(tableSyntaxNode, openl, header, module);
    }

    @Override
    public XlsModuleOpenClass getModule() {
        return (XlsModuleOpenClass)super.getModule();
    }

    private CustomSpreadsheetResultOpenClass buildCustomSpreadsheetResultType(Spreadsheet spreadsheet) {
        Collection spreadsheetOpenClassFields = spreadsheet.getSpreadsheetType().getFields().stream().filter(e -> !"this".equals(e.getName())).collect(Collectors.toList());
        String typeName = "SpreadsheetResult" + spreadsheet.getName();
        CustomSpreadsheetResultOpenClass customSpreadsheetResultOpenClass = new CustomSpreadsheetResultOpenClass(typeName, spreadsheet.getRowNames(), spreadsheet.getColumnNames(), spreadsheet.getRowNamesForResultModel(), spreadsheet.getColumnNamesForResultModel(), this.getModule(), spreadsheet.isTableStructureDetails(), true, true);
        customSpreadsheetResultOpenClass.setMetaInfo((IMetaInfo)new TableMetaInfo("Spreadsheet", spreadsheet.getName(), spreadsheet.getSourceUrl()));
        for (IOpenField field : spreadsheetOpenClassFields) {
            CustomSpreadsheetResultField customSpreadsheetResultField = new CustomSpreadsheetResultField(customSpreadsheetResultOpenClass, field);
            customSpreadsheetResultOpenClass.addField((IOpenField)customSpreadsheetResultField);
        }
        return customSpreadsheetResultOpenClass;
    }

    @Override
    protected ExecutableRulesMethod createMethodShell() {
        boolean isTypeCustomSpreadsheetResult = SpreadsheetResult.class == this.getType().getInstanceClass() && !(this.getType() instanceof CustomSpreadsheetResultOpenClass) && !this.structureBuilder.isExistsReturnHeader() && OpenLSystemProperties.isCustomSpreadsheetTypesSupported(this.bindingContext.getExternalParams());
        Spreadsheet spreadsheet = new Spreadsheet(this.getHeader(), this);
        spreadsheet.setSpreadsheetType(this.spreadsheetOpenClass);
        spreadsheet.setRowNames(this.structureBuilder.getRowNames());
        spreadsheet.setColumnNames(this.structureBuilder.getColumnNames());
        spreadsheet.setRowNamesForResultModel(this.structureBuilder.getRowNamesForResultModel());
        spreadsheet.setColumnNamesForResultModel(this.structureBuilder.getColumnNamesForResultModel());
        spreadsheet.getTableStructureDetails(Boolean.TRUE.equals(this.getTableSyntaxNode().getTableProperties().getTableStructureDetails()));
        if (isTypeCustomSpreadsheetResult) {
            try {
                CustomSpreadsheetResultOpenClass type = this.buildCustomSpreadsheetResultType(spreadsheet);
                IOpenClass bindingContextType = this.bindingContext.addType("org.openl.this", (IOpenClass)type);
                spreadsheet.setCustomSpreadsheetResultType((CustomSpreadsheetResultOpenClass)bindingContextType);
            }
            catch (Exception | LinkageError e) {
                String message = String.format("Cannot define type '%s'.", "SpreadsheetResult" + spreadsheet.getName());
                SyntaxNodeException error = SyntaxNodeExceptionUtils.createError((String)message, (Throwable)e, (ISyntaxNode)this.getTableSyntaxNode());
                this.bindingContext.addError(error);
                spreadsheet.setCustomSpreadsheetResultType((CustomSpreadsheetResultOpenClass)this.bindingContext.findType("org.openl.this", "SpreadsheetResult" + spreadsheet.getName()));
            }
        }
        return spreadsheet;
    }

    public void validateRowsColumnsForResultModel(Spreadsheet spreadsheet) {
        long columnsForResultModelCount = Arrays.stream(spreadsheet.getColumnNamesForResultModel()).filter(Objects::nonNull).count();
        long rowsForResultModelCount = Arrays.stream(spreadsheet.getRowNamesForResultModel()).filter(Objects::nonNull).count();
        HashMap<String, Object> fNames = new HashMap<String, Object>();
        int warnCnt = 0;
        for (int i = 0; i < spreadsheet.getRowNamesForResultModel().length; ++i) {
            for (int j = 0; j < spreadsheet.getColumnNamesForResultModel().length; ++j) {
                String key;
                String v;
                boolean f;
                if (spreadsheet.getColumnNamesForResultModel()[j] == null || spreadsheet.getRowNamesForResultModel()[i] == null || warnCnt >= 10) continue;
                String fieldName = SpreadsheetStructureBuilder.getSpreadsheetCellFieldName(spreadsheet.getColumnNames()[j], spreadsheet.getRowNames()[i]);
                IOpenField field = spreadsheet.getSpreadsheetType().getField(fieldName);
                IOpenClass t = field.getType();
                while (t.isArray()) {
                    t = t.getComponentClass();
                }
                boolean bl = f = !JavaOpenClass.VOID.equals((Object)t) && !JavaOpenClass.CLS_VOID.equals((Object)t) && !NullOpenClass.the.equals(t);
                if (!f) continue;
                Object refName = columnsForResultModelCount == 1L ? "$" + spreadsheet.getRowNames()[i] : (rowsForResultModelCount == 1L ? "$" + spreadsheet.getColumnNames()[j] : fieldName);
                StringBuilder sb = new StringBuilder();
                if (columnsForResultModelCount == 1L) {
                    sb.append(ClassUtils.decapitalize((String)spreadsheet.getRowNamesForResultModel()[i]));
                } else if (rowsForResultModelCount == 1L) {
                    sb.append(ClassUtils.decapitalize((String)spreadsheet.getColumnNamesForResultModel()[j]));
                } else {
                    sb.append(ClassUtils.decapitalize((String)spreadsheet.getColumnNamesForResultModel()[j]));
                    sb.append(ClassUtils.capitalize((String)spreadsheet.getRowNamesForResultModel()[i]));
                }
                String fName = sb.toString();
                if (StringUtils.isBlank((CharSequence)fName)) {
                    fName = "_";
                }
                if ((v = (String)fNames.put(key = fName.length() > 1 ? Character.toLowerCase(fName.charAt(0)) + fName.substring(1) : fName.toLowerCase(), refName)) == null) continue;
                this.bindingContext.addMessage(OpenLMessagesUtils.newWarnMessage((String)String.format("Cells '%s' and '%s' conflict with each other in the spreadsheet output model.", v, refName), (ISyntaxNode)this.getTableSyntaxNode()));
                ++warnCnt;
            }
        }
    }

    public void preBind(IBindingContext bindingContext) throws SyntaxNodeException {
        if (!bindingContext.isExecutionMode()) {
            this.getTableSyntaxNode().setMetaInfoReader(new SpreadsheetMetaInfoReader(this));
        }
        this.bindingContext = Objects.requireNonNull(bindingContext, "bindingContext cannot be null");
        TableSyntaxNode tableSyntaxNode = this.getTableSyntaxNode();
        this.validateTableBody(tableSyntaxNode, bindingContext);
        IOpenMethodHeader header = this.getHeader();
        RulesModuleBindingContextHelper.compileAllTypesInSignature(header.getSignature(), bindingContext);
        this.structureBuilder = new SpreadsheetStructureBuilder(tableSyntaxNode, bindingContext, header, this.getModule());
        String headerType = header.getName() + "Type";
        OpenL openL = bindingContext.getOpenL();
        this.spreadsheetOpenClass = new SpreadsheetOpenClass(headerType, openL);
        Boolean autoType = tableSyntaxNode.getTableProperties().getAutoType();
        this.structureBuilder.addCellFields(this.spreadsheetOpenClass, autoType);
    }

    @Override
    public void finalizeBind(IBindingContext bindingContext) throws Exception {
        super.finalizeBind(bindingContext);
        ILogicalTable tableBody = this.getTableSyntaxNode().getTableBody();
        this.getTableSyntaxNode().getSubTables().put("business", tableBody);
        this.cells = this.structureBuilder.getCells();
        Spreadsheet spreadsheet = (Spreadsheet)this.getMethod();
        if (spreadsheet != null) {
            this.validateRowsColumnsForResultModel(spreadsheet);
            spreadsheet.setCells(this.cells);
            spreadsheet.setResultBuilder(this.structureBuilder.buildResultBuilder(spreadsheet, bindingContext));
        }
    }

    public SpreadsheetCell[][] getCells() {
        return this.cells;
    }

    private void validateTableBody(TableSyntaxNode tableSyntaxNode, IBindingContext bindingContext) throws SyntaxNodeException {
        ILogicalTable tableBody = tableSyntaxNode.getTableBody();
        if (tableBody == null) {
            throw SyntaxNodeExceptionUtils.createError((String)"Table has no body. Try to merge header cell horizontally to identify table.", (ISyntaxNode)this.getTableSyntaxNode());
        }
        int height = tableBody.getHeight();
        int width = tableBody.getWidth();
        if (height < 2 || width < 2) {
            String message = "Spreadsheet has empty body. Spreadsheet table should has at least 2x3 cells.";
            BindHelper.processWarn((String)message, (ISyntaxNode)tableSyntaxNode, (IBindingContext)bindingContext);
        }
    }

    public Spreadsheet getSpreadsheet() {
        return (Spreadsheet)this.getMethod();
    }

    public void updateDependency(BindingDependencies dependencies) {
        if (this.cells != null) {
            for (SpreadsheetCell[] cellArray : this.cells) {
                if (cellArray == null) continue;
                for (SpreadsheetCell cell : cellArray) {
                    CompositeMethod method;
                    if (cell == null || (method = (CompositeMethod)cell.getMethod()) == null) continue;
                    method.updateDependency(dependencies);
                }
            }
        }
    }

    @Override
    public void removeDebugInformation(IBindingContext cxt) throws Exception {
        if (cxt.isExecutionMode()) {
            super.removeDebugInformation(cxt);
            this.structureBuilder.getSpreadsheetStructureBuilderHolder().clear();
            this.bindingContext = null;
        }
    }
}

