/*
 * Decompiled with CFR 0.152.
 */
package org.openl.rules.calc;

import java.util.Map;
import org.openl.binding.BindingDependencies;
import org.openl.rules.annotations.Executable;
import org.openl.rules.binding.RulesBindingDependencies;
import org.openl.rules.calc.CustomSpreadsheetResultOpenClass;
import org.openl.rules.calc.SpreadsheetBoundNode;
import org.openl.rules.calc.SpreadsheetInvoker;
import org.openl.rules.calc.SpreadsheetOpenClass;
import org.openl.rules.calc.SpreadsheetResult;
import org.openl.rules.calc.element.SpreadsheetCell;
import org.openl.rules.calc.result.IResultBuilder;
import org.openl.rules.lang.xls.syntax.TableSyntaxNode;
import org.openl.rules.method.ExecutableRulesMethod;
import org.openl.rules.table.Point;
import org.openl.types.IOpenClass;
import org.openl.types.IOpenMethodHeader;
import org.openl.types.Invokable;
import org.openl.vm.IRuntimeEnv;

@Executable
public class Spreadsheet
extends ExecutableRulesMethod {
    public static final String SPREADSHEETRESULT_TYPE_PREFIX = "SpreadsheetResult";
    public static final String SPREADSHEETRESULT_SHORT_TYPE_PREFIX = "SR";
    private IResultBuilder resultBuilder;
    private SpreadsheetCell[][] cells;
    private String[] rowNames;
    private String[] columnNames;
    private String[] rowNamesForResultModel;
    private String[] columnNamesForResultModel;
    private boolean tableStructureDetails;
    private SpreadsheetOpenClass spreadsheetType;
    private volatile Invokable invoker;
    private CustomSpreadsheetResultOpenClass customSpreadsheetResultType;
    volatile Map<String, Point> fieldsCoordinates;

    public Spreadsheet() {
        super(null, null);
    }

    public Spreadsheet(IOpenMethodHeader header, SpreadsheetBoundNode boundNode) {
        super(header, boundNode);
        this.initProperties(this.getSyntaxNode().getTableProperties());
    }

    public IOpenClass getType() {
        return this.customSpreadsheetResultType == null ? super.getType() : this.customSpreadsheetResultType;
    }

    public void setCustomSpreadsheetResultType(CustomSpreadsheetResultOpenClass spreadsheetCustomResultType) {
        this.customSpreadsheetResultType = spreadsheetCustomResultType;
    }

    @Override
    public SpreadsheetBoundNode getBoundNode() {
        return (SpreadsheetBoundNode)super.getBoundNode();
    }

    public SpreadsheetCell[][] getCells() {
        return this.cells;
    }

    public BindingDependencies getDependencies() {
        RulesBindingDependencies bindingDependencies = new RulesBindingDependencies();
        this.getBoundNode().updateDependency(bindingDependencies);
        return bindingDependencies;
    }

    public IResultBuilder getResultBuilder() {
        return this.resultBuilder;
    }

    public String getSourceUrl() {
        TableSyntaxNode syntaxNode = this.getSyntaxNode();
        return syntaxNode == null ? null : syntaxNode.getUri();
    }

    public SpreadsheetOpenClass getSpreadsheetType() {
        return this.spreadsheetType;
    }

    public int getHeight() {
        return this.cells.length;
    }

    public void setCells(SpreadsheetCell[][] cells) {
        this.cells = cells;
    }

    public void setColumnNames(String[] colNames) {
        this.columnNames = colNames;
    }

    public void setResultBuilder(IResultBuilder resultBuilder) {
        this.resultBuilder = resultBuilder;
    }

    public void setRowNames(String[] rowNames) {
        this.rowNames = rowNames;
    }

    public String[] getRowNamesForResultModel() {
        return this.rowNamesForResultModel;
    }

    public void setRowNamesForResultModel(String[] rowNamesForResultModel) {
        this.rowNamesForResultModel = rowNamesForResultModel;
    }

    public String[] getColumnNamesForResultModel() {
        return this.columnNamesForResultModel;
    }

    public void setColumnNamesForResultModel(String[] columnNamesForResultModel) {
        this.columnNamesForResultModel = columnNamesForResultModel;
    }

    public void setSpreadsheetType(SpreadsheetOpenClass spreadsheetType) {
        this.spreadsheetType = spreadsheetType;
    }

    public int getWidth() {
        return this.cells.length == 0 ? 0 : this.cells[0].length;
    }

    public String[] getRowNames() {
        return this.rowNames;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public boolean isTableStructureDetails() {
        return this.tableStructureDetails;
    }

    public void getTableStructureDetails(boolean tableStructureDetails) {
        this.tableStructureDetails = tableStructureDetails;
    }

    @Override
    protected Object innerInvoke(Object target, Object[] params, IRuntimeEnv env) {
        return this.getInvoker().invoke(target, params, env);
    }

    protected Invokable createInvoker() {
        return new SpreadsheetInvoker(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Invokable getInvoker() {
        if (this.invoker == null) {
            Spreadsheet spreadsheet = this;
            synchronized (spreadsheet) {
                if (this.invoker == null) {
                    this.invoker = this.createInvoker();
                }
            }
        }
        return this.invoker;
    }

    public void setInvoker(SpreadsheetInvoker invoker) {
        this.invoker = invoker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Point> getFieldsCoordinates() {
        if (this.fieldsCoordinates == null) {
            Spreadsheet spreadsheet = this;
            synchronized (spreadsheet) {
                if (this.fieldsCoordinates == null) {
                    this.fieldsCoordinates = SpreadsheetResult.buildFieldsCoordinates(this.columnNames, this.rowNames, false, false);
                }
            }
        }
        return this.fieldsCoordinates;
    }
}

