/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser.sax;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.exceptions.OpenXML4JException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackageAccess;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.PackageRelationshipCollection;
import org.apache.poi.openxml4j.opc.PackagingURIHelper;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.util.XMLHelper;
import org.apache.poi.xssf.eventusermodel.XSSFReader;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.openl.excel.parser.ExcelParseException;
import org.openl.excel.parser.ExcelReader;
import org.openl.excel.parser.ExcelUtils;
import org.openl.excel.parser.ParserDateUtil;
import org.openl.excel.parser.SheetDescriptor;
import org.openl.excel.parser.TableStyles;
import org.openl.excel.parser.sax.MinimalStyleTable;
import org.openl.excel.parser.sax.SAXSheetDescriptor;
import org.openl.excel.parser.sax.SAXTableStyles;
import org.openl.excel.parser.sax.SheetHandler;
import org.openl.excel.parser.sax.StyleHandler;
import org.openl.excel.parser.sax.StyleIndexHandler;
import org.openl.excel.parser.sax.WorkbookHandler;
import org.openl.rules.table.IGridRegion;
import org.openl.util.FileTool;
import org.openl.util.FileUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class SAXReader
implements ExcelReader {
    private final ParserDateUtil parserDateUtil = new ParserDateUtil();
    private final String fileName;
    private File tempFile;
    private boolean use1904Windowing;
    private List<SAXSheetDescriptor> sheets;
    private MinimalStyleTable styleTable;

    public SAXReader(String fileName) {
        this.fileName = fileName;
        ExcelUtils.configureZipBombDetection();
    }

    public SAXReader(InputStream is) {
        this.tempFile = FileTool.toTempFile((InputStream)is, (String)"stream.xlsx");
        this.fileName = this.tempFile.getAbsolutePath();
        ExcelUtils.configureZipBombDetection();
    }

    public List<SAXSheetDescriptor> getSheets() {
        if (this.sheets == null) {
            try (ReadOnlyOPCPackage pkg = ReadOnlyOPCPackage.open(this.fileName);){
                XMLReader parser = XMLHelper.newXMLReader();
                WorkbookHandler handler = new WorkbookHandler();
                parser.setContentHandler(handler);
                XSSFReader r = new XSSFReader(pkg.pck);
                try (InputStream workbookData = r.getWorkbookData();){
                    parser.parse(new InputSource(workbookData));
                }
                this.use1904Windowing = handler.isUse1904Windowing();
                this.sheets = handler.getSheetDescriptors();
            }
            catch (IOException | ParserConfigurationException | OpenXML4JException | SAXException e) {
                throw new ExcelParseException(e);
            }
        }
        return this.sheets;
    }

    @Override
    public Object[][] getCells(SheetDescriptor sheet) {
        SAXSheetDescriptor saxSheet = (SAXSheetDescriptor)sheet;
        ReadOnlyOPCPackage pkg = ReadOnlyOPCPackage.open(this.fileName);
        try {
            XSSFReader r = new XSSFReader(pkg.pck);
            this.initializeNeededData(r, pkg.pck);
            XMLReader parser = XMLHelper.newXMLReader();
            SheetHandler handler = new SheetHandler(r.getSharedStringsTable(), this.use1904Windowing, this.styleTable, this.parserDateUtil);
            parser.setContentHandler(handler);
            try (InputStream sheetData = r.getSheet(saxSheet.getRelationId());){
                parser.parse(new InputSource(sheetData));
            }
            CellAddress start = handler.getStart();
            saxSheet.setFirstRowNum(start.getRow());
            saxSheet.setFirstColNum(start.getColumn());
            Object[][] objectArray = handler.getCells();
            if (pkg != null) {
                pkg.close();
            }
            return objectArray;
        }
        catch (Throwable throwable) {
            try {
                if (pkg != null) {
                    try {
                        pkg.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException | ParserConfigurationException | OpenXML4JException | SAXException e) {
                throw new ExcelParseException(e);
            }
        }
    }

    @Override
    public boolean isUse1904Windowing() {
        if (this.sheets == null) {
            this.getSheets();
        }
        return this.use1904Windowing;
    }

    @Override
    public TableStyles getTableStyles(SheetDescriptor sheet, IGridRegion tableRegion) {
        SAXSheetDescriptor saxSheet = (SAXSheetDescriptor)sheet;
        ReadOnlyOPCPackage pkg = ReadOnlyOPCPackage.open(this.fileName);
        try {
            XSSFReader r = new XSSFReader(pkg.pck);
            this.initializeNeededData(r, pkg.pck);
            XMLReader parser = XMLHelper.newXMLReader();
            StyleIndexHandler styleIndexHandler = new StyleIndexHandler(tableRegion, saxSheet.getIndex());
            parser.setContentHandler(styleIndexHandler);
            try (InputStream sheetData = r.getSheet(saxSheet.getRelationId());){
                parser.parse(new InputSource(sheetData));
            }
            SAXTableStyles sAXTableStyles = new SAXTableStyles(tableRegion, styleIndexHandler.getCellIndexes(), r.getStylesTable(), this.getSheetComments(pkg.pck, saxSheet), styleIndexHandler.getFormulas());
            if (pkg != null) {
                pkg.close();
            }
            return sAXTableStyles;
        }
        catch (Throwable throwable) {
            try {
                if (pkg != null) {
                    try {
                        pkg.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (IOException | ParserConfigurationException | OpenXML4JException | SAXException e) {
                throw new ExcelParseException(e);
            }
        }
    }

    @Override
    public void close() {
        this.styleTable = null;
        this.sheets = null;
        this.use1904Windowing = false;
        FileUtils.deleteQuietly((File)this.tempFile);
        this.tempFile = null;
        this.parserDateUtil.reset();
    }

    private void initializeNeededData(XSSFReader r, OPCPackage pkg) {
        if (this.sheets == null) {
            this.getSheets();
        }
        if (this.styleTable == null) {
            this.parseStyles(r, pkg);
        }
    }

    private void parseStyles(XSSFReader r, OPCPackage pkg) {
        ArrayList parts = pkg.getPartsByContentType(XSSFRelation.STYLES.getContentType());
        if (parts.isEmpty()) {
            return;
        }
        try (InputStream stylesData = r.getStylesData();){
            XMLReader styleParser = XMLHelper.newXMLReader();
            StyleHandler styleHandler = new StyleHandler();
            styleParser.setContentHandler(styleHandler);
            styleParser.parse(new InputSource(stylesData));
            this.styleTable = styleHandler.getStyleTable();
        }
        catch (IOException | ParserConfigurationException | OpenXML4JException | SAXException e) {
            throw new ExcelParseException(e);
        }
    }

    private CommentsTable getSheetComments(OPCPackage pkg, SAXSheetDescriptor sheet) {
        try {
            PackageRelationship workbookRel = pkg.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
            PackagePart workbookPart = pkg.getPart(workbookRel);
            PackageRelationship sheetRel = workbookPart.getRelationship(sheet.getRelationId());
            PackagePart sheetPart = pkg.getPart(PackagingURIHelper.createPartName((URI)sheetRel.getTargetURI()));
            PackageRelationshipCollection commentRelList = sheetPart.getRelationshipsByType(XSSFRelation.SHEET_COMMENTS.getRelation());
            if (commentRelList.size() > 0) {
                PackageRelationship commentRel = commentRelList.getRelationship(0);
                PackagePart commentPart = pkg.getPart(PackagingURIHelper.createPartName((URI)commentRel.getTargetURI()));
                return new CommentsTable(commentPart);
            }
            return null;
        }
        catch (IOException | InvalidFormatException e) {
            return null;
        }
    }

    private static class ReadOnlyOPCPackage
    implements AutoCloseable {
        final OPCPackage pck;

        static ReadOnlyOPCPackage open(String fileName) throws InvalidFormatException {
            OPCPackage pck = OPCPackage.open((String)fileName, (PackageAccess)PackageAccess.READ);
            return new ReadOnlyOPCPackage(pck);
        }

        private ReadOnlyOPCPackage(OPCPackage pck) {
            this.pck = pck;
        }

        @Override
        public void close() {
            this.pck.revert();
        }
    }
}

