/*
 * Decompiled with CFR 0.152.
 */
package org.openl.excel.parser.event;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.hssf.eventusermodel.HSSFEventFactory;
import org.apache.poi.hssf.eventusermodel.HSSFListener;
import org.apache.poi.hssf.eventusermodel.HSSFRequest;
import org.apache.poi.hssf.model.HSSFFormulaParser;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CellValueRecordInterface;
import org.apache.poi.hssf.record.EscherAggregate;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.PaletteRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordBase;
import org.apache.poi.hssf.record.RecordFactoryInputStream;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.aggregates.FormulaRecordAggregate;
import org.apache.poi.hssf.record.aggregates.SharedValueManager;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFShapeContainer;
import org.apache.poi.hssf.usermodel.HSSFShapeFactory;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.apache.poi.ss.formula.WorkbookDependentFormula;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.util.CellAddress;
import org.openl.excel.parser.TableStyles;
import org.openl.excel.parser.event.EventSheetDescriptor;
import org.openl.excel.parser.event.SharedValueListener;
import org.openl.excel.parser.event.StyleTrackingListener;
import org.openl.excel.parser.event.style.CommentsCollector;
import org.openl.excel.parser.event.style.EventTableStyles;
import org.openl.rules.table.IGridRegion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableStyleListener
implements HSSFListener {
    private final Logger log = LoggerFactory.getLogger(TableStyleListener.class);
    private final EventSheetDescriptor sheet;
    private final IGridRegion tableRegion;
    private TableStyles tableStyles;
    private List<HSSFComment> comments;
    private final Map<CellAddress, String> formulas = new HashMap<CellAddress, String>();
    private final List<EventSheetDescriptor> sheets = new ArrayList<EventSheetDescriptor>();
    private int sheetIndex = -1;
    private boolean sheetsSorted = false;
    private final int[][] cellIndexes;
    private PaletteRecord palette;
    private DirectoryNode directory;
    private final List<RecordBase> shapeRecords = new ArrayList<RecordBase>();
    private FormulaRecord currentFormula;
    private SharedValueManager sharedValueManager;

    public TableStyleListener(EventSheetDescriptor sheet, IGridRegion tableRegion) {
        this.sheet = sheet;
        this.tableRegion = tableRegion;
        this.cellIndexes = new int[IGridRegion.Tool.height(tableRegion)][IGridRegion.Tool.width(tableRegion)];
    }

    void process(String fileName) throws IOException {
        try (POIFSFileSystem poifs = new POIFSFileSystem(new File(fileName));){
            HSSFEventFactory factory = new HSSFEventFactory();
            HSSFRequest request = new HSSFRequest();
            SharedValueListener sharedFormulaListener = new SharedValueListener(this.sheet);
            request.addListenerForAllRecords((HSSFListener)sharedFormulaListener);
            factory.processWorkbookEvents(request, poifs);
            this.sharedValueManager = sharedFormulaListener.getSharedValueManager();
        }
        poifs = new POIFSFileSystem(new File(fileName));
        try {
            this.directory = poifs.getRoot();
            final StyleTrackingListener formatListener = new StyleTrackingListener(this);
            HSSFEventFactory factory = new HSSFEventFactory(){

                public void processEvents(HSSFRequest req, InputStream in) {
                    Record r;
                    RecordFactoryInputStream recordStream = new RecordFactoryInputStream(in, true);
                    while ((r = recordStream.nextRecord()) != null) {
                        formatListener.processRecord(r);
                    }
                }
            };
            HSSFRequest request = new HSSFRequest();
            request.addListenerForAllRecords((HSSFListener)formatListener);
            factory.processWorkbookEvents(request, poifs);
            if (this.palette == null) {
                this.palette = new PaletteRecord();
            }
            this.collectComments();
            this.tableStyles = new EventTableStyles(this.tableRegion, this.cellIndexes, formatListener.getExtendedFormats(), formatListener.getCustomFormats(), this.palette, formatListener.getFonts(), this.comments, this.formulas);
        }
        finally {
            poifs.close();
        }
    }

    public TableStyles getTableStyles() {
        return this.tableStyles;
    }

    public void processRecord(Record record) {
        this.processFormula(record);
        switch (record.getSid()) {
            case 133: {
                BoundSheetRecord bsr = (BoundSheetRecord)record;
                if (!bsr.getSheetname().equals(this.sheet.getName())) break;
                this.sheets.add(new EventSheetDescriptor(bsr.getSheetname(), this.sheets.size(), bsr.getPositionOfBof()));
                break;
            }
            case 2057: {
                BOFRecord bof = (BOFRecord)record;
                if (bof.getType() != 16) break;
                if (!this.sheetsSorted) {
                    this.sheets.sort(Comparator.comparingInt(EventSheetDescriptor::getOffset));
                    this.sheetsSorted = true;
                }
                ++this.sheetIndex;
                break;
            }
            case 146: {
                this.palette = (PaletteRecord)record;
                break;
            }
            case 6: {
                if (!this.isNeededSheet()) break;
                FormulaRecord r = (FormulaRecord)record;
                int row = r.getRow();
                short column = r.getColumn();
                if (!IGridRegion.Tool.contains(this.tableRegion, column, row)) break;
                this.currentFormula = (FormulaRecord)record;
                this.saveStyleIndex((CellValueRecordInterface)r, row, column);
                break;
            }
            case 252: 
            case 253: 
            case 513: 
            case 515: 
            case 516: 
            case 517: 
            case 638: {
                if (!this.isNeededSheet()) break;
                CellValueRecordInterface r = (CellValueRecordInterface)record;
                int row = r.getRow();
                short column = r.getColumn();
                if (!IGridRegion.Tool.contains(this.tableRegion, column, row)) break;
                this.saveStyleIndex(r, row, column);
                break;
            }
            case 28: 
            case 60: 
            case 93: 
            case 236: 
            case 438: {
                if (!this.isNeededSheet()) break;
                this.shapeRecords.add((RecordBase)record);
            }
        }
    }

    private void processFormula(Record record) {
        if (this.currentFormula != null) {
            int row = this.currentFormula.getRow();
            short column = this.currentFormula.getColumn();
            try {
                StringRecord cachedText = null;
                if (record instanceof StringRecord) {
                    cachedText = (StringRecord)record;
                } else {
                    this.currentFormula.setCachedResultBoolean(false);
                }
                FormulaRecordAggregate formulaAggregate = new FormulaRecordAggregate(this.currentFormula, cachedText, this.sharedValueManager);
                Ptg[] formulaTokens = formulaAggregate.getFormulaTokens();
                boolean workbookDependentFormula = Arrays.stream(formulaTokens).anyMatch(t -> t instanceof WorkbookDependentFormula);
                if (workbookDependentFormula) {
                    this.formulas.put(new CellAddress(row, (int)column), "");
                } else {
                    String formula = HSSFFormulaParser.toFormulaString(null, (Ptg[])formulaTokens);
                    this.formulas.put(new CellAddress(row, (int)column), formula);
                }
            }
            catch (Exception e) {
                this.log.error("Cannot read formula in sheet '{}' row {} column {}", new Object[]{this.sheet.getName(), row, column, e});
            }
            this.currentFormula = null;
        }
    }

    private void saveStyleIndex(CellValueRecordInterface r, int row, short column) {
        short styleIndex = r.getXFIndex();
        int internalRow = row - this.tableRegion.getTop();
        int internalCol = column - this.tableRegion.getLeft();
        this.cellIndexes[internalRow][internalCol] = styleIndex;
    }

    private boolean isNeededSheet() {
        return this.sheetIndex == this.sheet.getIndex();
    }

    private void collectComments() {
        int loc = this.findFirstDrawingRecord();
        if (loc >= 0) {
            EscherAggregate r;
            try {
                r = EscherAggregate.createAggregate(this.shapeRecords, (int)loc);
            }
            catch (Exception e) {
                this.log.error(e.getMessage(), (Throwable)e);
                this.comments = Collections.emptyList();
                return;
            }
            EscherContainerRecord dgContainer = r.getEscherContainer();
            if (dgContainer == null) {
                return;
            }
            EscherContainerRecord spgrContainer = (EscherContainerRecord)dgContainer.getChildContainers().get(0);
            List spgrChildren = spgrContainer.getChildContainers();
            CommentsCollector commentCollector = new CommentsCollector();
            for (int i = 1; i < spgrChildren.size(); ++i) {
                EscherContainerRecord spContainer = (EscherContainerRecord)spgrChildren.get(i);
                HSSFShapeFactory.createShapeTree((EscherContainerRecord)spContainer, (EscherAggregate)r, (HSSFShapeContainer)commentCollector, (DirectoryNode)this.directory);
            }
            this.comments = commentCollector.getComments();
        }
    }

    private int findFirstDrawingRecord() {
        int size = this.shapeRecords.size();
        for (int i = 0; i < size; ++i) {
            RecordBase rb = this.shapeRecords.get(i);
            if (!(rb instanceof Record) || ((Record)rb).getSid() != 236) continue;
            return i;
        }
        return -1;
    }
}

