/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl.module;

import org.openl.binding.IBindingContext;
import org.openl.binding.IBoundNode;
import org.openl.binding.impl.BindHelper;
import org.openl.binding.impl.module.ContextPropertyBinderUtils;
import org.openl.binding.impl.module.ParameterDeclarationNodeBinder;
import org.openl.binding.impl.module.ParameterNode;
import org.openl.syntax.ISyntaxNode;
import org.openl.syntax.impl.IdentifierNode;
import org.openl.types.IOpenClass;

public class ParameterDeclarationNodeBinderWithContextParameterSupport
extends ParameterDeclarationNodeBinder {
    protected void validateMetaData(ISyntaxNode syntaxNode, IBindingContext bindingContext) {
        if (syntaxNode.getNumberOfChildren() == 2) {
            IdentifierNode identifierNode = (IdentifierNode)syntaxNode.getChild(0);
            if (!"context".equals(identifierNode.getText())) {
                BindHelper.processError((String)"Illegal context parameter declaration.", (ISyntaxNode)syntaxNode.getChild(0), (IBindingContext)bindingContext);
            }
        } else {
            BindHelper.processError((String)"Illegal context parameter declaration.", (ISyntaxNode)syntaxNode, (IBindingContext)bindingContext);
        }
    }

    protected IBoundNode makeParameterNode(ISyntaxNode node, String name, IOpenClass type, IBindingContext bindingContext) {
        ISyntaxNode syntaxNode;
        if (node.getNumberOfChildren() > 2 && (syntaxNode = node.getChild(2)).getNumberOfChildren() == 2) {
            IdentifierNode contextPropertyIdentifierNode = (IdentifierNode)syntaxNode.getChild(1);
            String contextProperty = contextPropertyIdentifierNode.getText();
            String errorMessage = ContextPropertyBinderUtils.validateContextProperty(contextProperty, type, bindingContext);
            if (errorMessage != null) {
                contextProperty = null;
                BindHelper.processError((String)errorMessage, (ISyntaxNode)contextPropertyIdentifierNode, (IBindingContext)bindingContext);
            }
            return new ParameterNode(node, name, type, contextProperty);
        }
        return super.makeParameterNode(node, name, type, bindingContext);
    }
}

