/*
 * Decompiled with CFR 0.152.
 */
package org.openl.binding.impl;

import org.openl.binding.impl.ConstructorNode;
import org.openl.binding.impl.MethodUsage;
import org.openl.binding.impl.NodeType;
import org.openl.meta.IMetaInfo;
import org.openl.rules.lang.xls.types.DatatypeOpenClass;
import org.openl.rules.lang.xls.types.DatatypeOpenConstructor;
import org.openl.types.IOpenMethod;

public class ConstructorUsage
extends MethodUsage {
    private final ConstructorNode constructorNode;

    public ConstructorUsage(ConstructorNode constructorNode, int startPos, int endPos, IOpenMethod method) {
        super(startPos, endPos, method);
        this.constructorNode = constructorNode;
    }

    public ConstructorNode getConstructorNode() {
        return this.constructorNode;
    }

    @Override
    public String getDescription() {
        StringBuilder buf = new StringBuilder();
        if (this.isDatatype()) {
            IMetaInfo metaInfo = this.getMethod().getDeclaringClass().getMetaInfo();
            buf.append(metaInfo.getDisplayName(1)).append('\n');
        }
        return buf.append(this.constructorNode.getDescription()).toString();
    }

    @Override
    public NodeType getNodeType() {
        if (this.isDatatype()) {
            return NodeType.DATATYPE;
        }
        return NodeType.OTHER;
    }

    private boolean isDatatype() {
        IOpenMethod method = this.getMethod();
        return method instanceof DatatypeOpenConstructor && method.getDeclaringClass() instanceof DatatypeOpenClass;
    }
}

